/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateSignatureTest
extends Assert {
    static Log log = LogFactory.getLog((String)CreateSignatureTest.class.getName());
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private KeyPair kp = null;
    private DocumentBuilder db = XMLUtils.createDocumentBuilder((boolean)false);

    public CreateSignatureTest() throws Exception {
        Init.init();
        this.kp = KeyPairGenerator.getInstance("RSA").genKeyPair();
    }

    @Test
    public void testEmptyNodeSet() throws Exception {
        Document document = this.db.newDocument();
        Element element = document.createElementNS("http://www.usps.gov/", "Envelope");
        element.appendChild(document.createTextNode("\n"));
        document.appendChild(element);
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        element.appendChild(xMLSignature.getElement());
        ObjectContainer objectContainer = new ObjectContainer(document);
        objectContainer.setId("object-1");
        objectContainer.setMimeType("text/plain");
        xMLSignature.appendObject(objectContainer);
        ObjectContainer objectContainer2 = new ObjectContainer(document);
        objectContainer2.setId("object-2");
        objectContainer2.setMimeType("text/plain");
        objectContainer2.setEncoding("http://www.w3.org/2000/09/xmldsig#base64");
        objectContainer2.appendChild((Node)document.createTextNode("SSBhbSB0aGUgdGV4dC4="));
        xMLSignature.appendObject(objectContainer2);
        Transforms transforms = new Transforms(document);
        XPathContainer xPathContainer = new XPathContainer(document);
        xPathContainer.setXPath("self::text()");
        transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
        xMLSignature.addDocument("#object-1", transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, "http://www.w3.org/2000/09/xmldsig#Object");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + "src/test/resources/org/apache/xml/security/samples/input/keystore.jks") : new FileInputStream("src/test/resources/org/apache/xml/security/samples/input/keystore.jks");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("test", "xmlsecurity".toCharArray());
        xMLSignature.sign((Key)privateKey);
    }

    @Test
    public void testOne() throws Exception {
        this.doVerify(this.doSign());
        this.doVerify(this.doSign());
    }

    @Test
    public void testTwo() throws Exception {
        this.doSignWithCert();
    }

    @Test
    public void testWithNSPrefixDisabled() throws Exception {
        String string = ElementProxy.getDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#");
        try {
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
            this.doSign();
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)string);
        }
        catch (Exception exception) {
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)string);
            throw exception;
        }
    }

    @Test
    public void testXFilter2Signature() throws Exception {
        Document document = this.db.newDocument();
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        element.appendChild(xMLSignature.getElement());
        Transforms transforms = new Transforms(document);
        String string = "here()/ancestor::ds.Signature/parent::node()/descendant-or-self::*";
        XPath2FilterContainer xPath2FilterContainer = XPath2FilterContainer.newInstanceIntersect((Document)document, (String)string);
        xPath2FilterContainer.setXPathNamespaceContext("dsig-xpath", "http://www.w3.org/2002/06/xmldsig-filter2");
        Element element2 = xPath2FilterContainer.getElement();
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", element2);
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + "src/test/resources/org/apache/xml/security/samples/input/keystore.jks") : new FileInputStream("src/test/resources/org/apache/xml/security/samples/input/keystore.jks");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("test", "xmlsecurity".toCharArray());
        xMLSignature.sign((Key)privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        String string2 = new String(byteArrayOutputStream.toByteArray());
        document = this.db.parse(new ByteArrayInputStream(string2.getBytes()));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string3 = "//ds:Signature[1]";
        Element element3 = (Element)xPath.evaluate(string3, document, XPathConstants.NODE);
        XMLSignature xMLSignature2 = new XMLSignature(element3, "");
        CreateSignatureTest.assertTrue((boolean)xMLSignature2.checkSignatureValue((Key)keyStore.getCertificate("test").getPublicKey()));
    }

    private String doSign() throws Exception {
        PrivateKey privateKey = this.kp.getPrivate();
        Document document = this.db.newDocument();
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        Element element2 = XMLUtils.createElementInSignatureSpace((Document)document, (String)"CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        XMLSignature xMLSignature = new XMLSignature(document, null, signatureAlgorithm.getElement(), element2);
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addKeyInfo(this.kp.getPublic());
        xMLSignature.sign((Key)privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    private String doSignWithCert() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + "src/test/resources/test.jks") : new FileInputStream("src/test/resources/test.jks");
        keyStore.load(fileInputStream, "changeit".toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("mullan", "changeit".toCharArray());
        Document document = this.db.newDocument();
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate("mullan");
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        Element element2 = XMLUtils.createElementInSignatureSpace((Document)document, (String)"CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        XMLSignature xMLSignature = new XMLSignature(document, null, signatureAlgorithm.getElement(), element2);
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addKeyInfo(x509Certificate);
        xMLSignature.sign((Key)privateKey);
        X509Certificate x509Certificate2 = xMLSignature.getKeyInfo().getX509Certificate();
        xMLSignature.checkSignatureValue((Key)x509Certificate2.getPublicKey());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void doVerify(String string) throws Exception {
        Document document = this.db.parse(new ByteArrayInputStream(string.getBytes()));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element, "");
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        if (keyInfo == null) {
            throw new RuntimeException("No keyinfo");
        }
        PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
        if (publicKey == null) {
            throw new RuntimeException("No public key");
        }
        CreateSignatureTest.assertTrue((boolean)xMLSignature.checkSignatureValue((Key)publicKey));
    }
}

