/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.test.signature.XPointerResourceResolver;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECDSASignatureTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private static final String ECDSA_JKS = "src/test/resources/org/apache/xml/security/samples/input/ecdsa.jks";
    private static final String ECDSA_JKS_PASSWORD = "security";
    private KeyStore keyStore;
    private DocumentBuilder db;

    public ECDSASignatureTest() throws Exception {
        if (Security.getProvider("BC") == null) {
            Serializable serializable;
            Constructor<?> constructor = null;
            try {
                serializable = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                constructor = serializable.getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (constructor == null) {
                return;
            }
            serializable = (Provider)constructor.newInstance(new Object[0]);
            Security.insertProviderAt(serializable, 1);
        }
        this.db = XMLUtils.createDocumentBuilder((boolean)false);
        Init.init();
    }

    @Test
    public void testOne() throws Exception {
        if (Security.getProvider("BC") == null) {
            return;
        }
        this.keyStore = KeyStore.getInstance("JKS");
        this.keyStore.load(new FileInputStream(ECDSA_JKS), ECDSA_JKS_PASSWORD.toCharArray());
        this.doVerify(this.doSign());
        this.doVerify(this.doSign());
    }

    @Test
    public void testTwo() throws Exception {
        if (Security.getProvider("BC") == null) {
            return;
        }
        File file = this.makeDataFile("src/test/resources/org/apache/xml/security/samples/input/ecdsaSignature.xml");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doVerify(fileInputStream);
    }

    @Test
    @Ignore
    public void testThree() throws Exception {
        if (Security.getProvider("BC") == null) {
            return;
        }
        File file = this.makeDataFile("src/test/resources/at/buergerkarte/testresp.xml");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doVerify(fileInputStream);
    }

    private byte[] doSign() throws Exception {
        PrivateKey privateKey = (PrivateKey)this.keyStore.getKey("ECDSA", ECDSA_JKS_PASSWORD.toCharArray());
        Document document = this.db.newDocument();
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        Element element2 = XMLUtils.createElementInSignatureSpace((Document)document, (String)"CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        XMLSignature xMLSignature = new XMLSignature(document, null, signatureAlgorithm.getElement(), element2);
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate("ECDSA");
        xMLSignature.addKeyInfo(x509Certificate);
        xMLSignature.sign((Key)privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void doVerify(byte[] byArray) throws Exception {
        this.doVerify(new ByteArrayInputStream(byArray));
    }

    private void doVerify(InputStream inputStream) throws Exception {
        Document document = this.db.parse(inputStream);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element, "");
        xMLSignature.addResourceResolver((ResourceResolverSpi)new XPointerResourceResolver(element));
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        if (keyInfo == null) {
            throw new RuntimeException("No keyinfo");
        }
        X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
        if (x509Certificate == null) {
            throw new RuntimeException("No certificate");
        }
        ECDSASignatureTest.assertTrue((boolean)xMLSignature.checkSignatureValue(x509Certificate));
    }

    private File makeDataFile(String string) {
        if (BASEDIR != null && !"".equals(BASEDIR)) {
            return new File(BASEDIR + SEP + string);
        }
        return new File(string);
    }
}

