/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.File;
import java.security.Key;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HMACOutputLengthTest
extends Assert {
    static Log log = LogFactory.getLog((String)HMACOutputLengthTest.class.getName());
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");

    public HMACOutputLengthTest() throws Exception {
        Init.init();
    }

    @Test
    public void test_signature_enveloping_hmac_sha1_trunclen_0() throws Exception {
        block2: {
            try {
                this.validate("signature-enveloping-hmac-sha1-trunclen-0-attack.xml");
                HMACOutputLengthTest.fail((String)"Expected HMACOutputLength exception");
            }
            catch (XMLSignatureException xMLSignatureException) {
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block2;
                HMACOutputLengthTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    @Test
    public void test_signature_enveloping_hmac_sha1_trunclen_8() throws Exception {
        block2: {
            try {
                this.validate("signature-enveloping-hmac-sha1-trunclen-8-attack.xml");
            }
            catch (XMLSignatureException xMLSignatureException) {
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block2;
                HMACOutputLengthTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    @Test
    public void test_generate_hmac_sha1_40() throws Exception {
        block2: {
            Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
            XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#hmac-sha1", 40, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            try {
                xMLSignature.sign((Key)this.getSecretKey("secret".getBytes("ASCII")));
                HMACOutputLengthTest.fail((String)"Expected HMACOutputLength Exception");
            }
            catch (XMLSignatureException xMLSignatureException) {
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block2;
                HMACOutputLengthTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    private boolean validate(String string) throws Exception {
        File file = new File(BASEDIR + SEP + "src/test/resources" + SEP + "javax" + SEP + "xml" + SEP + "crypto" + SEP + "dsig" + SEP, string);
        Document document = XMLUtils.createDocumentBuilder((boolean)false).parse(file);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new Exception("Couldn't find signature Element");
        }
        Element element = (Element)nodeList.item(0);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toString());
        SecretKey secretKey = xMLSignature.createSecretKey("secret".getBytes("ASCII"));
        return xMLSignature.checkSignatureValue((Key)secretKey);
    }

    private SecretKey getSecretKey(final byte[] byArray) {
        return new SecretKey(){
            private static final long serialVersionUID = -6527915934685938837L;

            public String getFormat() {
                return "RAW";
            }

            public byte[] getEncoded() {
                return byArray;
            }

            public String getAlgorithm() {
                return "SECRET";
            }
        };
    }
}

