/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InvalidKeyTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");

    @Test
    public void test() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(BASEDIR + SEP + "src/test/resources/org/apache/xml/security/samples/input/truststore.jks");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(fileInputStream, "testpw".toCharArray());
        try {
            this.validate(keyStore.getCertificate("bedag-test").getPublicKey());
            throw new Exception("Failure expected on a DSA key");
        }
        catch (Exception exception) {
            this.validate(keyStore.getCertificate("a70-garaio-frontend-u").getPublicKey());
            return;
        }
    }

    private void validate(PublicKey publicKey) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(BASEDIR + SEP + "src/test/resources/org/apache/xml/security/samples/input/test-assertion.xml");
        Document document = XMLUtils.createDocumentBuilder((boolean)false).parse(fileInputStream);
        Node node = document.getFirstChild();
        while (!(node instanceof Element)) {
            node = node.getNextSibling();
        }
        Attr attr = ((Element)node).getAttributeNodeNS(null, "AssertionID");
        if (attr != null) {
            ((Element)node).setIdAttributeNode(attr, true);
        }
        NodeList nodeList = node.getChildNodes();
        Element element = (Element)nodeList.item(nodeList.getLength() - 1);
        XMLSignature xMLSignature = new XMLSignature(element, "");
        xMLSignature.checkSignatureValue((Key)publicKey);
    }

    static {
        Init.init();
    }
}

