/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessingInstructionTest
extends Assert {
    private static String dir;

    public ProcessingInstructionTest() {
        String string = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        dir = string + string2 + "src/test/resources" + string2 + "org" + string2 + "apache" + string2 + "xml" + string2 + "security" + string2 + "testcases" + string2;
    }

    @Test
    public void testProcessingInstruction() throws Exception {
        Object object;
        String string = dir + "upp_sign.xml";
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        File file = new File(string);
        Document document = documentBuilder.parse(new FileInputStream(file));
        for (Node node = document.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties").item(0); node != null; node = node.getFirstChild()) {
            if (!(node instanceof Element) || (object = ((Element)node).getAttributeNode("Id")) == null) continue;
            ((Element)node).setIdAttributeNode((Attr)object, true);
        }
        object = XPathFactory.newInstance();
        XPath xPath = ((XPathFactory)object).newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        String string3 = new File(".").toURI().toURL().toString();
        XMLSignature xMLSignature = new XMLSignature(element, string3);
        xMLSignature.addResourceResolver(FileResolver.getInstance());
        X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
        if (!xMLSignature.checkSignatureValue(x509Certificate)) {
            throw new Exception("Signature is invalid!");
        }
    }

    static {
        Init.init();
    }

    private static class FileResolver
    extends ResourceResolverSpi {
        private static FileResolver resolver = null;

        public static synchronized ResourceResolverSpi getInstance() {
            if (resolver == null) {
                resolver = new FileResolver();
            }
            return resolver;
        }

        private FileResolver() {
        }

        public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
            try {
                URI uRI = FileResolver.getNewURI(attr.getNodeValue(), string);
                FileInputStream fileInputStream = new FileInputStream(dir + "out.xml");
                XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)fileInputStream);
                xMLSignatureInput.setSourceURI(uRI.toString());
                return xMLSignatureInput;
            }
            catch (Exception exception) {
                throw new ResourceResolverException("generic.EmptyMessage", exception, attr, string);
            }
        }

        public boolean engineCanResolve(Attr attr, String string) {
            return attr != null && "out.xml".equals(attr.getNodeValue());
        }

        private static URI getNewURI(String string, String string2) throws URISyntaxException {
            URI uRI = null;
            uRI = string2 == null || "".equals(string2) ? new URI(string) : new URI(string2).resolve(string);
            if (uRI.getFragment() != null) {
                URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), null);
                return uRI2;
            }
            return uRI;
        }
    }
}

