/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.reference.ReferenceData;
import org.apache.xml.security.signature.reference.ReferenceNodeSetData;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureReferenceTest
extends Assert {
    public static final String DS_NS = "http://www.w3.org/2000/09/xmldsig#";
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    public static final String KEYSTORE_DIRECTORY = BASEDIR + "/src/test/resources/";
    public static final String KEYSTORE_PASSWORD_STRING = "changeit";
    public static final char[] KEYSTORE_PASSWORD = "changeit".toCharArray();

    public SignatureReferenceTest() throws Exception {
        Init.init();
        ElementProxy.setDefaultPrefix((String)DS_NS, (String)"ds");
    }

    @Test
    public void testSigningVerifyingReference() throws Throwable {
        Document document = this.getOriginalDocument();
        XMLSignature xMLSignature = this.signDocument(document);
        PublicKey publicKey = this.getPublicKey();
        SignatureReferenceTest.assertTrue((boolean)xMLSignature.checkSignatureValue((Key)publicKey));
        SignedInfo signedInfo = xMLSignature.getSignedInfo();
        SignatureReferenceTest.assertTrue((signedInfo.getLength() == 1 ? 1 : 0) != 0);
        Reference reference = signedInfo.item(0);
        ReferenceData referenceData = reference.getReferenceData();
        SignatureReferenceTest.assertNotNull((Object)referenceData);
        SignatureReferenceTest.assertTrue((boolean)(referenceData instanceof ReferenceNodeSetData));
        Element element = (Element)((ReferenceNodeSetData)referenceData).iterator().next();
        SignatureReferenceTest.assertNotNull((Object)element);
        SignatureReferenceTest.assertTrue((boolean)"root".equals(element.getLocalName()));
        Element element2 = (Element)document.getElementsByTagNameNS("http://ns.example.org/", "root").item(0);
        SignatureReferenceTest.assertNotNull((Object)element2);
        SignatureReferenceTest.assertEquals((Object)element, (Object)element2);
    }

    private KeyStore getKeyStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = new FileInputStream(KEYSTORE_DIRECTORY + "test.jks");
        keyStore.load(fileInputStream, KEYSTORE_PASSWORD);
        ((InputStream)fileInputStream).close();
        return keyStore;
    }

    private PublicKey getPublicKey() throws Exception {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return keyStore.getCertificate(string).getPublicKey();
        }
        return null;
    }

    private PrivateKey getPrivateKey() throws Exception {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return (PrivateKey)keyStore.getKey(string, KEYSTORE_PASSWORD);
        }
        return null;
    }

    private Document getOriginalDocument() throws Throwable {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS("http://ns.example.org/", "root");
        element.appendChild(document.createTextNode("Hello World!"));
        document.appendChild(element);
        return document;
    }

    private XMLSignature signDocument(Document document) throws Throwable {
        XMLSignature xMLSignature = new XMLSignature(document, "", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        Element element = document.getDocumentElement();
        element.appendChild(xMLSignature.getElement());
        xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new ResolverXPointer());
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addKeyInfo(this.getPublicKey());
        xMLSignature.sign((Key)this.getPrivateKey());
        return xMLSignature;
    }
}

