/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureTest
extends Assert {
    public static final String DS_NS = "http://www.w3.org/2000/09/xmldsig#";
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    public static final String KEYSTORE_DIRECTORY = BASEDIR + "/src/test/resources/";
    public static final String KEYSTORE_PASSWORD_STRING = "changeit";
    public static final char[] KEYSTORE_PASSWORD = "changeit".toCharArray();

    public SignatureTest() throws Exception {
        Init.init();
        ElementProxy.setDefaultPrefix((String)DS_NS, (String)"ds");
    }

    @Test
    public void testSigning() throws Throwable {
        this.signDocument(this.getOriginalDocument());
    }

    @Test
    public void testSigningVerifyingFromRebuildSignature() throws Throwable {
        Document document = this.getOriginalDocument();
        this.signDocument(document);
        Element element = (Element)document.getElementsByTagNameNS(DS_NS, "Signature").item(0);
        XMLSignature xMLSignature = new XMLSignature(element, "");
        PublicKey publicKey = this.getPublicKey();
        SignatureTest.assertTrue((boolean)xMLSignature.checkSignatureValue((Key)publicKey));
    }

    @Test
    public void testSigningVerifyingFromExistingSignature() throws Throwable {
        Document document = this.getOriginalDocument();
        XMLSignature xMLSignature = this.signDocument(document);
        PublicKey publicKey = this.getPublicKey();
        SignatureTest.assertTrue((boolean)xMLSignature.checkSignatureValue((Key)publicKey));
    }

    @Test
    public void testSigningVerifyingFromExistingSignatureSameThread() throws Throwable {
        Document document = this.getOriginalDocument();
        XMLSignature xMLSignature = this.signDocument(document);
        PublicKey publicKey = this.getPublicKey();
        VerifyingRunnable verifyingRunnable = new VerifyingRunnable(xMLSignature, publicKey);
        verifyingRunnable.run();
        if (verifyingRunnable.throwable != null) {
            throw verifyingRunnable.throwable;
        }
        SignatureTest.assertTrue((boolean)verifyingRunnable.result);
    }

    @Test
    public void testSigningVerifyingFromExistingSignatureSeparateThread() throws Throwable {
        Document document = this.getOriginalDocument();
        XMLSignature xMLSignature = this.signDocument(document);
        PublicKey publicKey = this.getPublicKey();
        VerifyingRunnable verifyingRunnable = new VerifyingRunnable(xMLSignature, publicKey);
        Thread thread = new Thread(verifyingRunnable);
        thread.start();
        thread.join();
        if (verifyingRunnable.throwable != null) {
            throw verifyingRunnable.throwable;
        }
        SignatureTest.assertTrue((boolean)verifyingRunnable.result);
    }

    private KeyStore getKeyStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = new FileInputStream(KEYSTORE_DIRECTORY + "test.jks");
        keyStore.load(fileInputStream, KEYSTORE_PASSWORD);
        ((InputStream)fileInputStream).close();
        return keyStore;
    }

    private PublicKey getPublicKey() throws Exception {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return keyStore.getCertificate(string).getPublicKey();
        }
        return null;
    }

    private PrivateKey getPrivateKey() throws Exception {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return (PrivateKey)keyStore.getKey(string, KEYSTORE_PASSWORD);
        }
        return null;
    }

    private Document getOriginalDocument() throws Throwable {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS("http://ns.example.org/", "root");
        element.appendChild(document.createTextNode("Hello World!"));
        document.appendChild(element);
        return document;
    }

    private XMLSignature signDocument(Document document) throws Throwable {
        XMLSignature xMLSignature = new XMLSignature(document, "", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        Element element = document.getDocumentElement();
        element.appendChild(xMLSignature.getElement());
        xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new ResolverXPointer());
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addKeyInfo(this.getPublicKey());
        xMLSignature.sign((Key)this.getPrivateKey());
        return xMLSignature;
    }

    public static class VerifyingRunnable
    implements Runnable {
        public volatile Throwable throwable;
        public volatile boolean result;
        private XMLSignature signature;
        private PublicKey pubKey;

        public VerifyingRunnable(XMLSignature xMLSignature, PublicKey publicKey) {
            this.signature = xMLSignature;
            this.pubKey = publicKey;
        }

        public void run() {
            try {
                this.result = this.signature.checkSignatureValue((Key)this.pubKey);
            }
            catch (XMLSignatureException xMLSignatureException) {
                this.throwable = xMLSignatureException;
            }
        }
    }
}

