/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UnknownAlgoSignatureTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    protected static final String KEYSTORE_TYPE = "JKS";
    protected static final String KEYSTORE_FILE = "src/test/resources/org/apache/xml/security/samples/input/keystore.jks";
    protected static final String CERT_ALIAS = "test";
    protected static final String SIGNATURE_SOURCE_PATH = "src/test/resources/org/apache/xml/security/temp/signature";
    protected PublicKey publicKey;

    public UnknownAlgoSignatureTest() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + KEYSTORE_FILE) : new FileInputStream(KEYSTORE_FILE);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        keyStore.load(fileInputStream, null);
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(CERT_ALIAS);
        this.publicKey = x509Certificate.getPublicKey();
    }

    @Test
    public void testGood() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSignatureException, XMLSecurityException, XPathExpressionException {
        UnknownAlgoSignatureTest.assertTrue((boolean)this.checkSignature("signature-good.xml"));
    }

    @Test
    public void testBadC14NAlgo() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException, XPathExpressionException {
        try {
            UnknownAlgoSignatureTest.assertTrue((boolean)this.checkSignature("signature-bad-c14n-algo.xml"));
            UnknownAlgoSignatureTest.fail((String)"Exception not caught");
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            // empty catch block
        }
    }

    @Test
    public void testBadSigAlgo() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException, XPathExpressionException {
        try {
            UnknownAlgoSignatureTest.assertTrue((boolean)this.checkSignature("signature-bad-sig-algo.xml"));
            UnknownAlgoSignatureTest.fail((String)"Exception not caught");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    @Test
    public void testBadTransformAlgo() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException, XPathExpressionException {
        try {
            UnknownAlgoSignatureTest.assertTrue((boolean)this.checkReferences("signature-bad-transform-algo.xml"));
            UnknownAlgoSignatureTest.fail((String)"Exception not caught");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    protected boolean checkSignature(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException, XPathExpressionException {
        XMLSignature xMLSignature = this.unmarshalXMLSignature(string);
        return xMLSignature.checkSignatureValue((Key)this.publicKey);
    }

    protected boolean checkReferences(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException, XPathExpressionException {
        XMLSignature xMLSignature = this.unmarshalXMLSignature(string);
        return xMLSignature.getSignedInfo().verify(false);
    }

    private XMLSignature unmarshalXMLSignature(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException, XPathExpressionException {
        File file = null;
        file = BASEDIR != null && !"".equals(BASEDIR) ? new File(BASEDIR + SEP + SIGNATURE_SOURCE_PATH, string) : new File(SIGNATURE_SOURCE_PATH, string);
        Document document = UnknownAlgoSignatureTest.getDocument(file);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        return new XMLSignature(element, file.toURI().toURL().toString());
    }

    public static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.parse(new FileInputStream(file));
        return document;
    }

    static {
        Init.init();
    }
}

