/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.junit.Assert;
import org.junit.Test;

public class XMLSignatureInputTest
extends Assert {
    static Log log = LogFactory.getLog((String)XMLSignatureInputTest.class.getName());
    static final String _octetStreamTextInput = "Kleiner Test";
    static final String _nodeSetInput1 = "<?xml version=\"1.0\"?>\n<!DOCTYPE doc [\n<!ELEMENT doc (n+)>\n<!ELEMENT n (#PCDATA)>\n]>\n<!-- full document with decl --><doc><n>1</n><n>2</n><n>3</n><n>4</n></doc>";
    static final int _nodeSetInput1Nodes = 11;
    static final int _nodeSetInput1NodesWithComments = 12;
    static final String _nodeSetInput2 = "<?xml version=\"1.0\"?>\n<!-- full document --><doc><n>1</n><n>2</n><n>3</n><n>4</n></doc>";
    static final int _nodeSetInput2Nodes = 11;
    static final int _nodeSetInput2NodesWithComments = 12;
    static final String _nodeSetInput3 = "<!-- document --><doc><n>1</n><n>2</n><n>3</n><n>4</n></doc>";
    static final int _nodeSetInput3Nodes = 11;
    static final int _nodeSetInput3NodesWithComments = 12;

    @Test
    public void testSetOctetStreamGetOctetStream() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_octetStreamTextInput.getBytes("UTF-8"));
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = xMLSignatureInput.getOctetStream();
        int n = 0;
        while (inputStream.available() > 0) {
            byArray = new byte[1024];
            int n2 = inputStream.read(byArray);
            byteArrayOutputStream.write(byArray, n, n2);
            n += n2;
        }
        byArray = byteArrayOutputStream.toByteArray();
        String string = new String(byArray, "UTF-8");
        XMLSignatureInputTest.assertTrue((boolean)string.equals(_octetStreamTextInput));
    }

    @Test
    public void testIsInitializedWithOctetStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_octetStreamTextInput.getBytes());
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)byteArrayInputStream);
        XMLSignatureInputTest.assertTrue((String)"Input is initialized", (boolean)xMLSignatureInput.isInitialized());
    }

    @Test
    public void testOctetStreamIsOctetStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_octetStreamTextInput.getBytes());
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)byteArrayInputStream);
        XMLSignatureInputTest.assertTrue((String)"Input is octet stream", (boolean)xMLSignatureInput.isOctetStream());
    }

    @Test
    public void testOctetStreamIsNotNodeSet() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_octetStreamTextInput.getBytes());
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)byteArrayInputStream);
        XMLSignatureInputTest.assertTrue((String)"Input is not node set", (!xMLSignatureInput.isNodeSet() ? 1 : 0) != 0);
    }

    static {
        Init.init();
    }
}

