/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPointerResourceResolver
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(XPointerResourceResolver.class);
    private static final String XP_OPEN = "xpointer(";
    private static final String XNS_OPEN = "xmlns(";
    private Node baseNode;

    public XPointerResourceResolver(Node node) {
        this.baseNode = node;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        int n;
        String string2;
        String string3 = attr.getNodeValue();
        if (string3 == null || string3.length() <= 0) {
            return false;
        }
        if (string3.charAt(0) != '#') {
            return false;
        }
        try {
            string2 = URLDecoder.decode(string3, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"utf-8 not a valid encoding", (Throwable)unsupportedEncodingException);
            return false;
        }
        String[] stringArray = string2.substring(1).split("\\s");
        if (stringArray.length == 1 && !stringArray[0].startsWith(XNS_OPEN)) {
            return true;
        }
        for (n = 0; n < stringArray.length - 1; ++n) {
            if (stringArray[n].endsWith(")") && stringArray[n].startsWith(XNS_OPEN)) continue;
            return false;
        }
        if (!stringArray[n].endsWith(")") || !stringArray[n].startsWith(XP_OPEN)) {
            return false;
        }
        log.debug((Object)("xpURI = " + string2));
        log.debug((Object)("BaseURI = " + string));
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        int n;
        String string2;
        String string3 = attr.getNodeValue();
        if (string3.charAt(0) != '#') {
            return null;
        }
        try {
            string2 = URLDecoder.decode(string3, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"utf-8 not a valid encoding ", (Throwable)unsupportedEncodingException);
            return null;
        }
        String[] stringArray = string2.substring(1).split("\\s");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray.length > 1) {
            for (n = 0; n < stringArray.length - 1; ++n) {
                if (!stringArray[n].endsWith(")") || !stringArray[n].startsWith(XNS_OPEN)) {
                    return null;
                }
                object = stringArray[n].substring(XNS_OPEN.length(), stringArray[n].length() - 1);
                int n2 = ((String)object).indexOf(61);
                if (n2 <= 0 || n2 >= ((String)object).length() - 1) {
                    throw new ResourceResolverException("malformed namespace part of XPointer expression", attr, string);
                }
                hashMap.put(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
            }
        }
        try {
            Object object2;
            Object object3;
            object = null;
            NodeList nodeList = null;
            if (n == 0 && !stringArray[n].startsWith(XP_OPEN)) {
                object = this.baseNode.getOwnerDocument().getElementById(stringArray[n]);
            } else {
                if (!stringArray[n].endsWith(")") || !stringArray[n].startsWith(XP_OPEN)) {
                    return null;
                }
                object3 = stringArray[n].substring(XP_OPEN.length(), stringArray[n].length() - 1);
                object2 = XPathFactory.newInstance();
                XPath xPath = ((XPathFactory)object2).newXPath();
                DSNamespaceContext dSNamespaceContext = new DSNamespaceContext(hashMap);
                xPath.setNamespaceContext(dSNamespaceContext);
                nodeList = (NodeList)xPath.evaluate((String)object3, this.baseNode, XPathConstants.NODESET);
                if (nodeList.getLength() == 0) {
                    return null;
                }
                if (nodeList.getLength() == 1) {
                    object = nodeList.item(0);
                }
            }
            object3 = null;
            if (object != null) {
                object3 = new XMLSignatureInput((Node)object);
            } else if (nodeList != null) {
                object2 = new HashSet(nodeList.getLength());
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object2.add(nodeList.item(i));
                }
                object3 = new XMLSignatureInput((Set)object2);
            } else {
                return null;
            }
            object3.setMIMEType("text/xml");
            object3.setExcludeComments(true);
            object3.setSourceURI(string != null ? string.concat(string3) : string3);
            return object3;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ResourceResolverException("Problem evaluating XPath expression", (Exception)xPathExpressionException, attr, string);
        }
    }
}

