/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSecTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    static Log log = LogFactory.getLog((String)XmlSecTest.class.getName());

    @Test
    public void testCheckXmlSignatureSoftwareStack() throws Exception {
        this.checkXmlSignatureSoftwareStack(false);
    }

    @Test
    public void testCheckXmlSignatureSoftwareStackWithCert() throws Exception {
        this.checkXmlSignatureSoftwareStack(true);
    }

    private void checkXmlSignatureSoftwareStack(boolean bl) throws Exception {
        KeyStore keyStore;
        Object object;
        Object object2;
        Init.init();
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS("urn:namespace", "tns:document");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "urn:namespace");
        document.appendChild(element);
        Element element2 = document.createElementNS("urn:childnamespace", "t:child");
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:t", "urn:childnamespace");
        element2.appendChild(document.createTextNode("hello world"));
        element.appendChild(element2);
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        X509Certificate x509Certificate = null;
        if (bl) {
            object2 = System.getProperty("file.separator");
            object = new FileInputStream(BASEDIR + (String)object2 + "src/test/resources" + (String)object2 + "test.jks");
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load((InputStream)object, "changeit".toCharArray());
            x509Certificate = (X509Certificate)keyStore.getCertificate("mullan");
            publicKey = x509Certificate.getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey("mullan", "changeit".toCharArray());
        } else {
            object2 = KeyPairGenerator.getInstance("DSA").generateKeyPair();
            publicKey = ((KeyPair)object2).getPublic();
            privateKey = ((KeyPair)object2).getPrivate();
        }
        object2 = new XMLSignature(document, "", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        object = object2.getElement();
        element.appendChild((Node)object);
        keyStore = new Transforms(document);
        XPathContainer xPathContainer = new XPathContainer(document);
        xPathContainer.setXPathNamespaceContext("ds", "http://www.w3.org/2000/09/xmldsig#");
        xPathContainer.setXPath("not(ancestor-or-self::ds:Signature)");
        keyStore.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
        keyStore.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        object2.addDocument("", (Transforms)keyStore, "http://www.w3.org/2000/09/xmldsig#sha1");
        if (bl) {
            object2.addKeyInfo(x509Certificate);
        } else {
            object2.addKeyInfo(publicKey);
        }
        Element element3 = document.createElementNS(null, "nsElement");
        element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        object2.sign((Key)privateKey);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string = "//ds:Signature[1]";
        Element element4 = (Element)xPath.evaluate(string, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element4, "");
        boolean bl2 = xMLSignature.checkSignatureValue((Key)publicKey);
        XmlSecTest.assertTrue((boolean)bl2);
    }
}

