/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.transforms.implementations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class TransformBase64DecodeTest
extends Assert {
    static Log log = LogFactory.getLog((String)TransformBase64DecodeTest.class.getName());

    @Test
    public void test1() throws Exception {
        String string = "VGhlIFVSSSBvZiB0aGUgdHJhbnNmb3JtIGlzIGh0dHA6Ly93d3cudzMub3JnLzIwMDAvMDkveG1s\nZHNpZyNiYXNlNjQ=";
        Document document = TransformBase64DecodeTest.createDocument();
        Transforms transforms = new Transforms(document);
        document.appendChild(transforms.getElement());
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)new ByteArrayInputStream(string.getBytes()));
        XMLSignatureInput xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput);
        String string2 = new String(xMLSignatureInput2.getBytes());
        TransformBase64DecodeTest.assertTrue((boolean)string2.equals("The URI of the transform is http://www.w3.org/2000/09/xmldsig#base64"));
    }

    @Test
    public void test2() throws Exception {
        String string = "VkdobElGVlNTU0J2WmlCMGFHVWdkSEpoYm5ObWIzSnRJR2x6SUdoMGRIQTZMeTkzZDNjdWR6TXVi\nM0puTHpJd01EQXZNRGt2ZUcxcwpaSE5wWnlOaVlYTmxOalE9";
        Document document = TransformBase64DecodeTest.createDocument();
        Transforms transforms = new Transforms(document);
        document.appendChild(transforms.getElement());
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)new ByteArrayInputStream(string.getBytes()));
        XMLSignatureInput xMLSignatureInput2 = transforms.performTransforms(transforms.performTransforms(xMLSignatureInput));
        String string2 = new String(xMLSignatureInput2.getBytes());
        TransformBase64DecodeTest.assertTrue((boolean)string2.equals("The URI of the transform is http://www.w3.org/2000/09/xmldsig#base64"));
    }

    @Test
    public void test3() throws Exception {
        String string = "<Object xmlns:signature='http://www.w3.org/2000/09/xmldsig#'>\n<signature:Base64>\nVGhlIFVSSSBvZiB0aGU   gdHJhbn<RealText>Nmb  3JtIGlzIG<test/>h0dHA6</RealText>Ly93d3cudzMub3JnLzIwMDAvMDkveG1s\nZHNpZyNiYXNlNjQ=\n</signature:Base64>\n</Object>\n";
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Base64";
        Node node = (Node)xPath.evaluate(string2, document, XPathConstants.NODE);
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(node);
        Document document2 = TransformBase64DecodeTest.createDocument();
        Transforms transforms = new Transforms(document2);
        document2.appendChild(transforms.getElement());
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
        XMLSignatureInput xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput);
        String string3 = new String(xMLSignatureInput2.getBytes());
        TransformBase64DecodeTest.assertTrue((String)("\"" + string3 + "\""), (boolean)string3.equals("The URI of the transform is http://www.w3.org/2000/09/xmldsig#base64"));
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder((boolean)false);
        Document document = documentBuilder.newDocument();
        if (document == null) {
            throw new RuntimeException("Could not create a Document");
        }
        log.debug((Object)"I could create the Document");
        return document;
    }

    static {
        Init.init();
    }
}

