/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.transforms.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.test.DSNamespaceContext;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformXSLTTest
extends Assert {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    private static final String SOURCE_PATH = "src/test/resources/com/phaos/phaos-xmldsig-three/";
    private static final String SIGNATURE_FILE = "signature-rsa-detached-xslt-transform.xml";
    private static final String STYLESHEET_FILE = "document-stylesheet.xml";
    static Log log = LogFactory.getLog((String)TransformXSLTTest.class.getName());

    @Test
    public void test1() throws Exception {
        File file = null;
        File file2 = null;
        if (BASEDIR != null && !"".equals(BASEDIR)) {
            file = new File(BASEDIR + SEP + SOURCE_PATH, SIGNATURE_FILE);
            file2 = new File(BASEDIR + SEP + SOURCE_PATH, STYLESHEET_FILE);
        } else {
            file = new File(SOURCE_PATH, SIGNATURE_FILE);
            file = new File(SOURCE_PATH, STYLESHEET_FILE);
        }
        Document document = TransformXSLTTest.getDocument(file);
        Document document2 = TransformXSLTTest.getDocument(file2);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string = "//ds:Transform[1]";
        Element element = (Element)xPath.evaluate(string, document, XPathConstants.NODE);
        Transform transform = new Transform(document, "http://www.w3.org/TR/1999/REC-xslt-19991116", element.getChildNodes());
        transform.performTransform(new XMLSignatureInput((Node)document2));
    }

    private static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.createDocumentBuilder((boolean)false).parse(new FileInputStream(file));
    }

    static {
        Init.init();
    }
}

