/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test
extends Assert {
    static Log log = LogFactory.getLog((String)Base64Test.class.getName());

    @Test
    public void testA1() throws Exception {
        String string = "Hallo";
        String string2 = Base64.encode((byte[])string.getBytes("UTF-8"));
        Base64Test.assertNotNull((String)"Result of encoding result0", (Object)string2);
        byte[] byArray = Base64.decode((String)string2);
        String string3 = new String(byArray, "UTF-8");
        Base64Test.assertEquals((String)"Result of decoding", (long)0L, (long)string.compareTo(string3));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64.decode((byte[])string2.getBytes(), (OutputStream)byteArrayOutputStream);
        string3 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        Base64Test.assertEquals((String)"Result of decoding", (long)0L, (long)string.compareTo(string3));
    }

    @Test
    public void testWrap1() throws UnsupportedEncodingException, Exception {
        String string = "The quick brown fox jumps over the lazy dog and some extr";
        String string2 = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wcyBvdmVyIHRoZSBsYXp5IGRvZyBhbmQgc29tZSBleHRy";
        String string3 = Base64.encode((byte[])string.getBytes("UTF-8"));
        Base64Test.assertEquals((String)"Result of encoding", (Object)string3, (Object)string2);
        String string4 = new String(Base64.decode((String)string3), "UTF-8");
        Base64Test.assertEquals((String)"Result of encoding", (Object)string4, (Object)string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64.decode((byte[])string2.getBytes(), (OutputStream)byteArrayOutputStream);
        string4 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        Base64Test.assertEquals((String)"Result of encoding", (Object)string4, (Object)string);
    }

    @Test
    public void testWrap2() throws UnsupportedEncodingException, Exception {
        String string = "The quick brown fox jumps over the lazy dog and some extra text that will cause a line wrap";
        String string2 = null;
        string2 = XMLUtils.ignoreLineBreaks() ? "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wcyBvdmVyIHRoZSBsYXp5IGRvZyBhbmQgc29tZSBleHRyYSB0ZXh0IHRoYXQgd2lsbCBjYXVzZSBhIGxpbmUgd3JhcA==" : "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wcyBvdmVyIHRoZSBsYXp5IGRvZyBhbmQgc29tZSBleHRy\nYSB0ZXh0IHRoYXQgd2lsbCBjYXVzZSBhIGxpbmUgd3JhcA==";
        String string3 = Base64.encode((byte[])string.getBytes("UTF-8"));
        Base64Test.assertEquals((String)"Result of encoding", (Object)string3, (Object)string2);
        String string4 = new String(Base64.decode((String)string3), "UTF-8");
        Base64Test.assertEquals((String)"Result of encoding", (Object)string4, (Object)string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64.decode((byte[])string2.getBytes(), (OutputStream)byteArrayOutputStream);
        string4 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        Base64Test.assertEquals((String)"Result of encoding", (Object)string4, (Object)string);
    }

    static {
        Init.init();
    }
}

