/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils.resolver;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class OfflineResolver
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)OfflineResolver.class.getName());
    static Map<String, String> _uriMap = null;
    static Map<String, String> _mimeMap = null;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        try {
            String string2 = attr.getNodeValue();
            if (_uriMap.containsKey(string2)) {
                String string3 = _uriMap.get(string2);
                log.debug((Object)("Mapped " + string2 + " to " + string3));
                FileInputStream fileInputStream = new FileInputStream(string3);
                log.debug((Object)("Available bytes = " + ((InputStream)fileInputStream).available()));
                XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)fileInputStream);
                xMLSignatureInput.setSourceURI(string2);
                xMLSignatureInput.setMIMEType(_mimeMap.get(string2));
                return xMLSignatureInput;
            }
            Object[] objectArray = new Object[]{"The URI " + string2 + " is not configured for offline work"};
            throw new ResourceResolverException("generic.EmptyMessage", objectArray, attr, string);
        }
        catch (IOException iOException) {
            throw new ResourceResolverException("generic.EmptyMessage", (Exception)iOException, attr, string);
        }
    }

    public boolean engineCanResolve(Attr attr, String string) {
        String string2 = attr.getNodeValue();
        if (string2.equals("") || string2.startsWith("#")) {
            return false;
        }
        URI uRI = null;
        try {
            uRI = OfflineResolver.getNewURI(attr.getNodeValue(), string);
            if (uRI.getScheme().equals("http")) {
                log.debug((Object)("I state that I can resolve " + uRI.toString()));
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    private static void register(String string, String string2, String string3) {
        _uriMap.put(string, string2);
        _mimeMap.put(string, string3);
    }

    private static URI getNewURI(String string, String string2) throws URISyntaxException {
        URI uRI = null;
        uRI = string2 == null || "".equals(string2) ? new URI(string) : new URI(string2).resolve(string);
        if (uRI.getFragment() != null) {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), null);
            return uRI2;
        }
        return uRI;
    }

    static {
        Init.init();
        _uriMap = new HashMap<String, String>();
        _mimeMap = new HashMap<String, String>();
        String string = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir") + "/";
        OfflineResolver.register("http://www.w3.org/TR/xml-stylesheet", string + "src/test/resources/org/w3c/www/TR/xml-stylesheet.html", "text/html");
        OfflineResolver.register("http://www.w3.org/TR/2000/REC-xml-20001006", string + "src/test/resources/org/w3c/www/TR/2000/REC-xml-20001006", "text/xml");
        OfflineResolver.register("http://www.nue.et-inf.uni-siegen.de/index.html", string + "src/test/resources/org/apache/xml/security/temp/nuehomepage", "text/html");
        OfflineResolver.register("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/id2.xml", string + "src/test/resources/org/apache/xml/security/temp/id2.xml", "text/xml");
        OfflineResolver.register("http://xmldsig.pothole.com/xml-stylesheet.txt", string + "src/test/resources/com/pothole/xmldsig/xml-stylesheet.txt", "text/xml");
        OfflineResolver.register("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", string + "src/test/resources/ie/baltimore/merlin-examples/merlin-xmldsig-twenty-three/xml-stylesheet.b64", "text/plain");
    }
}

