/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils.resolver;

import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.implementations.ResolverDirectHTTP;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class ResolverDirectHTTPTest
extends Assert {
    private static final String url = "http://www.apache.org";
    private static final String proxyHost = "127.0.0.1";
    private static final String proxyPort = "3128";
    private static final String proxyUsername = "proxyUser";
    private static final String proxyPassword = "proxyPass";
    private static final String serverUsername = "serverUser";
    private static final String serverPassword = "serverPass";

    @Before
    public void setUp() {
        Init.init();
    }

    @Test
    public void testBug40783() throws Exception {
        Init.init();
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("id");
        attr.setNodeValue("urn:ddd:uuu");
        document.createElement("test").setAttributeNode(attr);
        try {
            ResourceResolver resourceResolver = ResourceResolver.getInstance((Attr)attr, null);
            ResolverDirectHTTPTest.fail((String)("No exception thrown, but resolver found: " + resourceResolver));
        }
        catch (ResourceResolverException resourceResolverException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testProxyAuth() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setNodeValue(url);
        ResolverDirectHTTP resolverDirectHTTP = new ResolverDirectHTTP();
        resolverDirectHTTP.engineSetProperty("http.proxy.host", proxyHost);
        resolverDirectHTTP.engineSetProperty("http.proxy.port", proxyPort);
        resolverDirectHTTP.engineSetProperty("http.proxy.username", proxyUsername);
        resolverDirectHTTP.engineSetProperty("http.proxy.password", proxyPassword);
        resolverDirectHTTP.engineResolve(attr, url);
    }

    @Test
    @Ignore
    public void testProxyAuthWithWrongPassword() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setNodeValue(url);
        ResolverDirectHTTP resolverDirectHTTP = new ResolverDirectHTTP();
        resolverDirectHTTP.engineSetProperty("http.proxy.host", proxyHost);
        resolverDirectHTTP.engineSetProperty("http.proxy.port", proxyPort);
        resolverDirectHTTP.engineSetProperty("http.proxy.username", proxyUsername);
        resolverDirectHTTP.engineSetProperty("http.proxy.password", "wrongPassword");
        try {
            resolverDirectHTTP.engineResolve(attr, url);
            Assert.fail((String)"Expected ResourceResolverException");
        }
        catch (ResourceResolverException resourceResolverException) {
            Assert.assertEquals((Object)"Server returned HTTP response code: 407 for URL: http://www.apache.org", (Object)resourceResolverException.getMessage());
        }
    }

    @Test
    @Ignore
    public void testServerAuth() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setNodeValue(url);
        ResolverDirectHTTP resolverDirectHTTP = new ResolverDirectHTTP();
        resolverDirectHTTP.engineSetProperty("http.basic.username", serverUsername);
        resolverDirectHTTP.engineSetProperty("http.basic.password", serverPassword);
        resolverDirectHTTP.engineResolve(attr, url);
    }

    @Test
    @Ignore
    public void testServerAuthWithWrongPassword() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setNodeValue(url);
        ResolverDirectHTTP resolverDirectHTTP = new ResolverDirectHTTP();
        resolverDirectHTTP.engineSetProperty("http.basic.username", serverUsername);
        resolverDirectHTTP.engineSetProperty("http.basic.password", "wrongPassword");
        try {
            resolverDirectHTTP.engineResolve(attr, url);
            Assert.fail((String)"Expected ResourceResolverException");
        }
        catch (ResourceResolverException resourceResolverException) {
            Assert.assertEquals((Object)"Server returned HTTP response code: 401 for URL: http://www.apache.org", (Object)resourceResolverException.getMessage());
        }
    }

    @Test
    @Ignore
    public void testProxyAndServerAuth() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setNodeValue(url);
        ResolverDirectHTTP resolverDirectHTTP = new ResolverDirectHTTP();
        resolverDirectHTTP.engineSetProperty("http.proxy.host", proxyHost);
        resolverDirectHTTP.engineSetProperty("http.proxy.port", proxyPort);
        resolverDirectHTTP.engineSetProperty("http.proxy.username", proxyUsername);
        resolverDirectHTTP.engineSetProperty("http.proxy.password", proxyPassword);
        resolverDirectHTTP.engineSetProperty("http.basic.username", serverUsername);
        resolverDirectHTTP.engineSetProperty("http.basic.password", serverPassword);
        resolverDirectHTTP.engineResolve(attr, url);
    }
}

