/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.utils.resolver;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class ResourceResolverTest
extends Assert {
    static Log log = LogFactory.getLog((String)ResourceResolverTest.class.getName());

    @Test
    public void testCustomResolver() throws Exception {
        String string = "org.apache.xml.security.test.utils.resolver.OfflineResolver";
        ResourceResolver.registerAtStart((String)string);
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        attr.setValue("http://www.apache.org");
        ResourceResolver resourceResolver = ResourceResolver.getInstance((Attr)attr, (String)"http://www.apache.org");
        try {
            attr.setValue("http://xmldsig.pothole.com/xml-stylesheet.txt");
            resourceResolver.resolve(attr, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ResourceResolverTest.fail((String)(attr.getValue() + " should be resolvable by the OfflineResolver"));
        }
        try {
            attr.setValue("http://www.apache.org");
            resourceResolver.resolve(attr, null);
            ResourceResolverTest.fail((String)(attr.getValue() + " should not be resolvable by the OfflineResolver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLocalFileWithEmptyBaseURI() throws Exception {
        Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
        Attr attr = document.createAttribute("URI");
        String string = System.getProperty("basedir");
        String string2 = new File(string, "build.xml").toURI().toString();
        attr.setValue(string2);
        ResourceResolver resourceResolver = ResourceResolver.getInstance((Attr)attr, (String)string2);
        try {
            resourceResolver.resolve(attr, "");
        }
        catch (Exception exception) {
            ResourceResolverTest.fail((String)exception.getMessage());
        }
    }

    static {
        Init.init();
    }
}

