/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.version;

import java.security.Provider;
import java.security.Security;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest
extends Assert {
    @Test
    public void testConvertVersion() throws Exception {
        String string = this.convertVersion("1.4.4");
        VersionTest.assertTrue((boolean)"1.44".equals(string));
        string = this.convertVersion("1.4.4-SNAPSHOT");
        VersionTest.assertTrue((boolean)"1.44".equals(string));
        string = this.convertVersion("1.4");
        VersionTest.assertTrue((boolean)"1.4".equals(string));
    }

    @Test
    public void testVersion() throws Exception {
        Security.addProvider((Provider)new XMLDSigRI());
        Provider provider = Security.getProvider("ApacheXMLDSig");
        VersionTest.assertTrue((provider != null ? 1 : 0) != 0);
        String string = System.getProperty("product.version");
        VersionTest.assertTrue((string != null ? 1 : 0) != 0);
        string = this.convertVersion(string);
        double d = Double.parseDouble(string);
        VersionTest.assertTrue((d == provider.getVersion() ? 1 : 0) != 0);
        VersionTest.assertTrue((boolean)provider.getInfo().contains("Santuario"));
    }

    private String convertVersion(String string) {
        int n = string.indexOf(45);
        if (n != -1) {
            string = string.substring(0, n);
        }
        int n2 = string.lastIndexOf(46);
        if (string.indexOf(46) != n2) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, string.length());
            string = string2.concat(string3);
        }
        return string;
    }
}

