/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.encryption;

import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.utils.JavaUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Decrypter {
    static Log log = LogFactory.getLog((String)Decrypter.class.getName());

    private static Document loadEncryptionDocument() throws Exception {
        String string = "build/encryptedInfo.xml";
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        System.out.println("Encryption document loaded from " + file.toURI().toURL().toString());
        return document;
    }

    private static SecretKey loadKeyEncryptionKey() throws Exception {
        String string = "build/kek";
        String string2 = "DESede";
        File file = new File(string);
        DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(JavaUtils.getBytesFromFile((String)string));
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
        SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
        System.out.println("Key encryption key loaded from " + file.toURI().toURL().toString());
        return secretKey;
    }

    private static void outputDocToFile(Document document, String string) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        transformer.transform(dOMSource, streamResult);
        fileOutputStream.close();
        System.out.println("Wrote document containing decrypted data to " + file.toURI().toURL().toString());
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = Decrypter.loadEncryptionDocument();
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        SecretKey secretKey = Decrypter.loadKeyEncryptionKey();
        String string = "BC";
        XMLCipher xMLCipher = XMLCipher.getInstance();
        xMLCipher.init(2, null);
        xMLCipher.setKEK((Key)secretKey);
        xMLCipher.doFinal(document, element);
        Decrypter.outputDocToFile(document, "build/decryptedInfo.xml");
    }

    static {
        Init.init();
    }
}

