/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.encryption;

import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Encrypter {
    static Log log = LogFactory.getLog((String)Encrypter.class.getName());

    private static Document createSampleDocument() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS("http://www.apache.org/ns/#app1", "apache:RootElement");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:apache", "http://www.apache.org/ns/#app1");
        document.appendChild(element);
        element.appendChild(document.createTextNode("\n"));
        Element element2 = document.createElementNS("http://www.apache.org/ns/#app1", "apache:foo");
        element2.appendChild(document.createTextNode("Some simple text"));
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
        return document;
    }

    private static SecretKey GenerateAndStoreKeyEncryptionKey() throws Exception {
        String string = "DESede";
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] byArray = secretKey.getEncoded();
        File file = new File("build/kek");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        System.out.println("Key encryption key stored in " + file.toURI().toURL().toString());
        return secretKey;
    }

    private static SecretKey GenerateDataEncryptionKey() throws Exception {
        String string = "AES";
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    private static void outputDocToFile(Document document, String string) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        transformer.transform(dOMSource, streamResult);
        fileOutputStream.close();
        System.out.println("Wrote document containing encrypted data to " + file.toURI().toURL().toString());
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = Encrypter.createSampleDocument();
        SecretKey secretKey = Encrypter.GenerateDataEncryptionKey();
        SecretKey secretKey2 = Encrypter.GenerateAndStoreKeyEncryptionKey();
        String string = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        XMLCipher xMLCipher = XMLCipher.getInstance((String)string);
        xMLCipher.init(3, (Key)secretKey2);
        EncryptedKey encryptedKey = xMLCipher.encryptKey(document, (Key)secretKey);
        Element element = document.getDocumentElement();
        string = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        XMLCipher xMLCipher2 = XMLCipher.getInstance((String)string);
        xMLCipher2.init(1, (Key)secretKey);
        EncryptedData encryptedData = xMLCipher2.getEncryptedData();
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfo);
        xMLCipher2.doFinal(document, element, true);
        Encrypter.outputDocToFile(document, "build/encryptedInfo.xml");
    }

    static {
        Init.init();
    }
}

