/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.iaik;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.samples.DSNamespaceContext;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesFifteen;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesSixteen;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesTwentyThree;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverAnonymous;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IAIKInterOp {
    static Log log = LogFactory.getLog((String)IAIKInterOp.class.getName());
    static final boolean schemaValidate = false;
    static final String signatureSchemaFile = "samples/data/xmldsig-core-schema.xsd";

    public static void main(String[] stringArray) {
        String string;
        int n;
        System.out.println("We do not schema-validation");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String string2 = "samples/data/at/iaik/ixsil/";
        String[] stringArray2 = new String[]{string2 + "signatureAlgorithms/signatures/hMACSignature.xml", string2 + "signatureAlgorithms/signatures/hMACShortSignature.xml", string2 + "signatureAlgorithms/signatures/dSASignature.xml", string2 + "signatureAlgorithms/signatures/rSASignature.xml", string2 + "transforms/signatures/base64DecodeSignature.xml", string2 + "transforms/signatures/c14nSignature.xml", string2 + "coreFeatures/signatures/manifestSignature.xml", string2 + "transforms/signatures/xPathSignature.xml", string2 + "coreFeatures/signatures/signatureTypesSignature.xml", string2 + "transforms/signatures/envelopedSignatureSignature.xml"};
        IAIKInterOp.verifyAnonymous(string2, documentBuilderFactory);
        for (n = 0; n < 2; ++n) {
            string = stringArray2[n];
            try {
                VerifyMerlinsExamplesFifteen.verifyHMAC(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("The XML signature in file " + string + " crashed the application (bad)");
                exception.printStackTrace();
                System.out.println();
            }
        }
        for (n = 2; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            try {
                VerifyMerlinsExamplesSixteen.verify(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("The XML signature in file " + string + " crashed the application (bad)");
                exception.printStackTrace();
                System.out.println();
            }
        }
        for (n = 2; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            try {
                VerifyMerlinsExamplesTwentyThree.verify(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("The XML signature in file " + string + " crashed the application (bad)");
                exception.printStackTrace();
                System.out.println();
            }
        }
    }

    public static void verifyAnonymous(String string, DocumentBuilderFactory documentBuilderFactory) {
        String string2 = string + "coreFeatures/signatures/anonymousReferenceSignature.xml";
        try {
            String string3 = string + "coreFeatures/samples/anonymousReferenceContent.xml";
            ResolverAnonymous resolverAnonymous = new ResolverAnonymous(string3);
            File file = new File(string2);
            System.out.println("Try to verify " + file.toURI().toURL().toString());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new FileInputStream(file));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            xPath.setNamespaceContext(new DSNamespaceContext());
            String string4 = "//ds:Signature[1]";
            Element element = (Element)xPath.evaluate(string4, document, XPathConstants.NODE);
            XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString());
            xMLSignature.setFollowNestedManifests(false);
            xMLSignature.addResourceResolver((ResourceResolverSpi)resolverAnonymous);
            KeyInfo keyInfo = xMLSignature.getKeyInfo();
            if (keyInfo != null) {
                X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
                if (x509Certificate != null) {
                    System.out.println("The XML signature in file " + file.toURI().toURL().toString() + " is " + (xMLSignature.checkSignatureValue(x509Certificate) ? "valid (good)" : "invalid !!!!! (bad)"));
                } else {
                    PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
                    if (publicKey != null) {
                        System.out.println("The XML signature in file " + file.toURI().toURL().toString() + " is " + (xMLSignature.checkSignatureValue((Key)publicKey) ? "valid (good)" : "invalid !!!!! (bad)"));
                    } else {
                        System.out.println("Did not find a public key, so I can't check the signature");
                    }
                }
            } else {
                System.out.println("Did not find a KeyInfo");
            }
        }
        catch (Exception exception) {
            System.out.println("The XML signature in file " + string2 + " crashed the application (bad)");
            exception.printStackTrace();
            System.out.println();
        }
    }

    static {
        Init.init();
    }
}

