/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateCollectableSignature {
    static Log log = LogFactory.getLog((String)CreateCollectableSignature.class.getName());
    public static final String passphrase = "The super-mega-secret public static passphrase";

    public static void main(String[] stringArray) throws Exception {
        File file = new File("build/collectableSignature.xml");
        String string = file.toURI().toURL().toString();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS(null, "root");
        document.appendChild(element);
        Element element2 = document.createElementNS(null, "signedContent");
        element2.appendChild(document.createTextNode("Signed Text\n"));
        element.appendChild(element2);
        XMLSignature xMLSignature = new XMLSignature(document, string, "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        element2.appendChild(xMLSignature.getElement());
        Object object = element2.getNamespaceURI();
        boolean bl = object != null && ((String)object).length() > 0;
        String string2 = element2.getNodeName();
        Transforms transforms = new Transforms(document);
        XPathContainer xPathContainer = new XPathContainer(document);
        xPathContainer.setXPathNamespaceContext("ds", "http://www.w3.org/2000/09/xmldsig#");
        if (bl) {
            xPathContainer.setXPathNamespaceContext("root", (String)object);
        }
        String string3 = "\ncount(                                                                 \n ancestor-or-self::" + (bl ? "root:" : "") + string2 + "" + "\n" + " |                                                                     " + "\n" + " here()/ancestor::" + (bl ? "root:" : "") + string2 + "[1] " + "\n" + ") <= count(                                                             " + "\n" + " ancestor-or-self::" + (bl ? "root:" : "") + string2 + "" + "\n" + ")                                                                      " + "\n" + " and                                                                   " + "\n" + "count(                                                                 " + "\n" + " ancestor-or-self::ds:Signature                                        " + "\n" + " |                                                                     " + "\n" + " here()/ancestor::ds:Signature[1]                                      " + "\n" + ") > count(                                                             " + "\n" + " ancestor-or-self::ds:Signature                                        " + "\n" + ")                                                                      " + "\n";
        xPathContainer.setXPath(string3);
        transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.getKeyInfo().add(new KeyName(document, passphrase));
        System.out.println("Start signing");
        xMLSignature.sign((Key)xMLSignature.createSecretKey(passphrase.getBytes()));
        System.out.println("Finished signing");
        object = new FileOutputStream(file);
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)object);
        ((FileOutputStream)object).close();
        System.out.println("Wrote signature to " + string);
        SignedInfo signedInfo = xMLSignature.getSignedInfo();
        for (int i = 0; i < signedInfo.getSignedContentLength(); ++i) {
            System.out.println("################ Signed Resource " + i + " ################");
            System.out.println(new String(signedInfo.getSignedContentItem(i)));
            System.out.println();
        }
    }

    static {
        Init.init();
    }
}

