/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.samples.utils.resolver.OfflineResolver;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateSignature {
    static Log log = LogFactory.getLog((String)CreateSignature.class.getName());

    public static void main(String[] stringArray) throws Exception {
        ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds");
        String string = "JKS";
        String string2 = "samples/data/keystore.jks";
        String string3 = "xmlsecurity";
        String string4 = "test";
        String string5 = "xmlsecurity";
        String string6 = "test";
        File file = new File("build/signature.xml");
        KeyStore keyStore = KeyStore.getInstance(string);
        FileInputStream fileInputStream = new FileInputStream(string2);
        keyStore.load(fileInputStream, string3.toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string4, string5.toCharArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("http://www.apache.org/ns/#app1", "apache:RootElement");
        element.setAttributeNS(null, "attr1", "test1");
        element.setAttributeNS(null, "attr2", "test2");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:foo", "http://example.org/#foo");
        element.setAttributeNS("http://example.org/#foo", "foo:attr1", "foo's test");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:apache", "http://www.apache.org/ns/#app1");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        String string7 = file.toURI().toURL().toString();
        XMLSignature xMLSignature = new XMLSignature(document, string7, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
        Object object = new Transforms(document);
        object.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        object.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", (Transforms)object, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addDocument("http://www.w3.org/TR/xml-stylesheet");
        xMLSignature.addDocument("http://www.nue.et-inf.uni-siegen.de/index.html");
        object = (X509Certificate)keyStore.getCertificate(string6);
        xMLSignature.addKeyInfo((X509Certificate)object);
        xMLSignature.addKeyInfo(((Certificate)object).getPublicKey());
        System.out.println("Start signing");
        xMLSignature.sign((Key)privateKey);
        System.out.println("Finished signing");
        object = new FileOutputStream(file);
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)object);
        ((FileOutputStream)object).close();
        System.out.println("Wrote signature to " + string7);
    }

    static {
        Init.init();
    }
}

