/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.samples.DSNamespaceContext;
import org.apache.xml.security.samples.signature.VerifyMerlinsExamplesSixteen;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VerifyMerlinsExamplesFifteen {
    static Log log = LogFactory.getLog((String)VerifyMerlinsExamplesFifteen.class.getName());
    static final boolean schemaValidate = false;
    static final String signatureSchemaFile = "samples/data/xmldsig-core-schema.xsd";

    public static void main(String[] stringArray) {
        System.out.println("We do not schema-validation");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String string = "samples/data/ie/baltimore/merlin-examples/merlin-xmldsig-fifteen/";
        String[] stringArray2 = new String[]{string + "signature-enveloping-hmac-sha1.xml", string + "signature-enveloped-dsa.xml", string + "signature-enveloping-b64-dsa.xml", string + "signature-enveloping-dsa.xml", string + "signature-enveloping-rsa.xml", string + "signature-external-b64-dsa.xml", string + "signature-external-dsa.xml"};
        try {
            VerifyMerlinsExamplesFifteen.verifyHMAC(documentBuilderFactory, stringArray2[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 1; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            try {
                VerifyMerlinsExamplesSixteen.verify(documentBuilderFactory, string2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void verifyHMAC(DocumentBuilderFactory documentBuilderFactory, String string) throws Exception {
        File file = new File(string);
        System.out.println("Try to verify " + file.toURI().toURL().toString());
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString());
        byte[] byArray = "secret".getBytes("ASCII");
        SecretKey secretKey = xMLSignature.createSecretKey(byArray);
        System.out.println("The XML signature in file " + file.toURI().toURL().toString() + " is " + (xMLSignature.checkSignatureValue((Key)secretKey) ? "valid (good)" : "invalid !!!!! (bad)"));
    }

    static {
        Init.init();
    }
}

