/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.samples.DSNamespaceContext;
import org.apache.xml.security.samples.utils.resolver.OfflineResolver;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VerifyMerlinsExamplesSixteen {
    static Log log = LogFactory.getLog((String)VerifyMerlinsExamplesSixteen.class.getName());
    static final boolean schemaValidate = false;
    static final String signatureSchemaFile = "samples/data/xmldsig-core-schema.xsd";

    public static void main(String[] stringArray) {
        System.out.println("We do not schema-validation");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String[] stringArray2 = new String[]{"samples/data/ie/baltimore/merlin-examples/merlin-xmldsig-sixteen/signature.xml"};
        int n = 0;
        int n2 = stringArray2.length;
        for (int i = n; i < n2; ++i) {
            String string = stringArray2[i];
            try {
                VerifyMerlinsExamplesSixteen.verify(documentBuilderFactory, string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void verify(DocumentBuilderFactory documentBuilderFactory, String string) throws Exception {
        File file = new File(string);
        System.out.println("Try to verify " + file.toURL().toString());
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DSNamespaceContext());
        String string2 = "//ds:Signature[1]";
        Element element = (Element)xPath.evaluate(string2, document, XPathConstants.NODE);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toURL().toString());
        xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
        xMLSignature.setFollowNestedManifests(false);
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        if (keyInfo != null) {
            X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
            if (x509Certificate != null) {
                System.out.println("The XML signature in file " + file.toURI().toURL().toString() + " is " + (xMLSignature.checkSignatureValue(x509Certificate) ? "valid (good)" : "invalid !!!!! (bad)"));
            } else {
                PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
                if (publicKey != null) {
                    System.out.println("The XML signature in file " + file.toURI().toURL().toString() + " is " + (xMLSignature.checkSignatureValue((Key)publicKey) ? "valid (good)" : "invalid !!!!! (bad)"));
                } else {
                    System.out.println("Did not find a public key, so I can't check the signature");
                }
            }
        } else {
            System.out.println("Did not find a KeyInfo");
        }
    }

    static {
        Init.init();
    }
}

