/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class ClassLoaderObjectDescription
extends AbstractObjectDescription {
    public ClassLoaderObjectDescription() {
        super(Object.class);
        this.setParameterDefinition("class", String.class);
    }

    @Override
    public Object createObject() {
        try {
            String o = (String)this.getParameter("class");
            return ObjectUtilities.getClassLoader(this.getClass()).loadClass(o).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new ObjectFactoryException("The Object is null.");
        }
        try {
            Constructor<?> c = o.getClass().getConstructor(new Class[0]);
            if (!Modifier.isPublic(c.getModifiers())) {
                throw new ObjectFactoryException("The given object has no public default constructor. [" + o.getClass() + "]");
            }
            this.setParameter("class", o.getClass().getName());
        }
        catch (Exception e) {
            throw new ObjectFactoryException("The given object has no default constructor. [" + o.getClass() + "]", e);
        }
    }
}

