/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.CommentHandler;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.util.BasicTypeSupport;
import org.jfree.xml.util.ObjectDescriptionException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModelReader {
    private static final int STATE_START = 0;
    private static final int IN_OBJECT = 1;
    private static final int IGNORE_OBJECT = 2;
    private static final int MAPPING_STATE = 3;
    private static final int CONSTRUCTOR_STATE = 4;
    private CommentHandler commentHandler = new CommentHandler();
    private String[] closeComment;
    private String[] openComment;

    protected CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    protected String[] getCloseComment() {
        return this.closeComment;
    }

    protected String[] getOpenComment() {
        return this.openComment;
    }

    protected void setCloseComment(String[] closeComment) {
        this.closeComment = closeComment;
    }

    protected void setOpenComment(String[] openComment) {
        this.openComment = openComment;
    }

    protected void parseXml(URL resource) throws ObjectDescriptionException {
        this.parseXmlDocument(resource, false);
    }

    protected void parseXmlDocument(URL resource, boolean isInclude) throws ObjectDescriptionException {
        try {
            BufferedInputStream in = new BufferedInputStream(resource.openStream());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            SAXModelHandler handler = new SAXModelHandler(resource, isInclude);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.getCommentHandler());
            }
            catch (SAXException se) {
                Log.debug((Object)"Comments are not supported by this SAX implementation.");
            }
            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(in));
            ((InputStream)in).close();
        }
        catch (Exception e) {
            Log.warn((Object)"Unable to load factory specifications", (Exception)e);
            throw new ObjectDescriptionException("Unable to load object factory specs.", e);
        }
    }

    protected void startRootDocument() {
    }

    protected void endRootDocument() {
    }

    protected void startIncludeHandling(URL resource) {
    }

    protected void endIncludeHandling() {
    }

    protected void handleIgnoredProperty(String name) {
    }

    protected abstract boolean handleManualMapping(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract boolean startObjectDefinition(String var1, String var2, boolean var3) throws ObjectDescriptionException;

    protected abstract void handleAttributeDefinition(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract void handleElementDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void handleLookupDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endObjectDefinition() throws ObjectDescriptionException;

    protected abstract void startMultiplexMapping(String var1, String var2);

    protected abstract void handleMultiplexMapping(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endMultiplexMapping() throws ObjectDescriptionException;

    protected abstract void handleConstructorDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected Class loadClass(String className) {
        if (className == null) {
            return null;
        }
        if (className.startsWith("::")) {
            return BasicTypeSupport.getClassRepresentation(className);
        }
        try {
            return ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
        }
        catch (Exception e) {
            Log.warn((Object)"Unable to load class", (Exception)e);
            return null;
        }
    }

    private class SAXModelHandler
    extends DefaultHandler {
        private URL resource;
        private int state;
        private Stack openComments;
        private boolean isInclude;

        public SAXModelHandler(URL resource, boolean isInclude) {
            if (resource == null) {
                throw new NullPointerException();
            }
            this.resource = resource;
            this.openComments = new Stack();
            this.isInclude = isInclude;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AbstractModelReader.this.setOpenComment(AbstractModelReader.this.getCommentHandler().getComments());
            this.openComments.push(AbstractModelReader.this.getOpenComment());
            AbstractModelReader.this.setCloseComment(null);
            try {
                if (!this.isInclude && qName.equals("objects")) {
                    AbstractModelReader.this.startRootDocument();
                    return;
                }
                if (this.getState() == 0) {
                    this.startRootElement(qName, attributes);
                } else {
                    if (this.getState() == 2) {
                        return;
                    }
                    if (this.getState() == 1) {
                        this.startObjectElement(qName, attributes);
                    } else if (this.getState() == 3) {
                        if (!qName.equals("type")) {
                            throw new SAXException("Expected 'type' tag");
                        }
                        String name = attributes.getValue("name");
                        String target = attributes.getValue("class");
                        AbstractModelReader.this.handleMultiplexMapping(name, target);
                    } else if (this.getState() == 4) {
                        if (!qName.equals("parameter")) {
                            throw new SAXException("Expected 'parameter' tag");
                        }
                        String parameterClass = attributes.getValue("class");
                        String tagName = attributes.getValue("property");
                        AbstractModelReader.this.handleConstructorDefinition(tagName, parameterClass);
                    }
                }
            }
            catch (ObjectDescriptionException e) {
                throw new SAXException((Exception)((Object)e));
            }
            finally {
                AbstractModelReader.this.getCommentHandler().clearComments();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            AbstractModelReader.this.setOpenComment((String[])this.openComments.pop());
            AbstractModelReader.this.setCloseComment(AbstractModelReader.this.getCommentHandler().getComments());
            try {
                if (!this.isInclude && qName.equals("objects")) {
                    AbstractModelReader.this.endRootDocument();
                    return;
                }
                if (qName.equals("object")) {
                    if (this.getState() != 2) {
                        AbstractModelReader.this.endObjectDefinition();
                    }
                    this.setState(0);
                } else if (qName.equals("mapping")) {
                    this.setState(0);
                    AbstractModelReader.this.endMultiplexMapping();
                } else if (qName.equals("constructor") && this.getState() != 2) {
                    this.setState(1);
                }
            }
            catch (ObjectDescriptionException e) {
                throw new SAXException((Exception)((Object)e));
            }
            finally {
                AbstractModelReader.this.getCommentHandler().clearComments();
            }
        }

        private void startObjectElement(String qName, Attributes attributes) throws ObjectDescriptionException {
            if (qName.equals("constructor")) {
                this.setState(4);
            } else if (qName.equals("lookup")) {
                String name = attributes.getValue("name");
                String lookupKey = attributes.getValue("lookup");
                AbstractModelReader.this.handleLookupDefinition(name, lookupKey);
            } else if (qName.equals("ignore")) {
                String name = attributes.getValue("name");
                AbstractModelReader.this.handleIgnoredProperty(name);
            } else if (qName.equals("element-property")) {
                String elementAtt = attributes.getValue("element");
                String name = attributes.getValue("name");
                AbstractModelReader.this.handleElementDefinition(name, elementAtt);
            } else if (qName.equals("attribute-property")) {
                String name = attributes.getValue("name");
                String attribName = attributes.getValue("attribute");
                String handler = attributes.getValue("handler");
                AbstractModelReader.this.handleAttributeDefinition(name, attribName, handler);
            }
        }

        private void startRootElement(String qName, Attributes attributes) throws SAXException, ObjectDescriptionException {
            if (qName.equals("include")) {
                if (this.isInclude) {
                    Log.warn((Object)"Ignored nested include tag.");
                    return;
                }
                String src = attributes.getValue("src");
                try {
                    URL url = new URL(this.resource, src);
                    AbstractModelReader.this.startIncludeHandling(url);
                    AbstractModelReader.this.parseXmlDocument(url, true);
                    AbstractModelReader.this.endIncludeHandling();
                }
                catch (Exception ioe) {
                    throw new ElementDefinitionException(ioe, "Unable to include file from " + src);
                }
            } else if (qName.equals("object")) {
                boolean ignored;
                this.setState(1);
                String className = attributes.getValue("class");
                String register = attributes.getValue("register-name");
                if (register != null && register.length() == 0) {
                    register = null;
                }
                if (!AbstractModelReader.this.startObjectDefinition(className, register, ignored = "true".equals(attributes.getValue("ignore")))) {
                    this.setState(2);
                }
            } else if (qName.equals("manual")) {
                String className = attributes.getValue("class");
                String readHandler = attributes.getValue("read-handler");
                String writeHandler = attributes.getValue("write-handler");
                AbstractModelReader.this.handleManualMapping(className, readHandler, writeHandler);
            } else if (qName.equals("mapping")) {
                this.setState(3);
                String typeAttr = attributes.getValue("type-attribute");
                String baseClass = attributes.getValue("base-class");
                AbstractModelReader.this.startMultiplexMapping(baseClass, typeAttr);
            }
        }

        private int getState() {
            return this.state;
        }

        private void setState(int state) {
            this.state = state;
        }
    }
}

