/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.TitleAnchor;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.JSONUtils;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.data.PieDataset3D;
import com.orsoncharts.data.StandardPieDataset3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.marker.CategoryMarker;
import com.orsoncharts.marker.RangeMarker;
import com.orsoncharts.marker.ValueMarker;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import com.orsoncharts.util.Orientation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.graphics2d.svg.SVGGraphics2D;

public class SVGDemo1 {
    static String generateSVGForChart(Chart3D chart3D, int n, int n2, String string) {
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(n, n2);
        sVGGraphics2D.setDefsKeyPrefix(string);
        chart3D.setElementHinting(true);
        chart3D.draw((Graphics2D)sVGGraphics2D, (Rectangle2D)new Rectangle(n, n2));
        return sVGGraphics2D.getSVGElement(chart3D.getID());
    }

    static PieDataset3D createPieChartDataset() {
        StandardPieDataset3D standardPieDataset3D = new StandardPieDataset3D();
        standardPieDataset3D.add((Comparable)((Object)"Milk Products"), 11625.0);
        standardPieDataset3D.add((Comparable)((Object)"Meat"), 5114.0);
        standardPieDataset3D.add((Comparable)((Object)"Wood/Logs"), 3060.0);
        standardPieDataset3D.add((Comparable)((Object)"Crude Oil"), 2023.0);
        standardPieDataset3D.add((Comparable)((Object)"Machinery"), 1865.0);
        standardPieDataset3D.add((Comparable)((Object)"Fruit"), 1587.0);
        standardPieDataset3D.add((Comparable)((Object)"Fish"), 1367.0);
        standardPieDataset3D.add((Comparable)((Object)"Wine"), 1177.0);
        standardPieDataset3D.add((Comparable)((Object)"Other"), 18870.0);
        return standardPieDataset3D;
    }

    static Chart3D createPieChart(String string) {
        Chart3D chart3D = Chart3DFactory.createPieChart((String)"New Zealand Exports 2012", (String)"http://www.stats.govt.nz/browse_for_stats/snapshots-of-nz/nz-in-profile-2013.aspx", (PieDataset3D)SVGDemo1.createPieChartDataset());
        chart3D.setID(string);
        chart3D.setTitleAnchor(TitleAnchor.TOP_LEFT);
        chart3D.setLegendPosition(LegendAnchor.BOTTOM_CENTER, Orientation.HORIZONTAL);
        return chart3D;
    }

    private static CategoryDataset3D createBarChartDataset() {
        StandardCategoryDataset3D standardCategoryDataset3D = new StandardCategoryDataset3D();
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.put((Comparable)((Object)"Q2/11"), (Object)8.181);
        defaultKeyedValues.put((Comparable)((Object)"Q3/11"), (Object)8.792);
        defaultKeyedValues.put((Comparable)((Object)"Q4/11"), (Object)9.039);
        defaultKeyedValues.put((Comparable)((Object)"Q1/12"), (Object)10.916);
        defaultKeyedValues.put((Comparable)((Object)"Q2/12"), (Object)8.181);
        defaultKeyedValues.put((Comparable)((Object)"Q3/12"), (Object)9.094);
        defaultKeyedValues.put((Comparable)((Object)"Q4/12"), (Object)8.958);
        defaultKeyedValues.put((Comparable)((Object)"Q1/13"), (Object)10.947);
        defaultKeyedValues.put((Comparable)((Object)"Q2/13"), (Object)8.372);
        defaultKeyedValues.put((Comparable)((Object)"Q3/13"), (Object)9.275);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Oracle"), (KeyedValues)defaultKeyedValues);
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.put((Comparable)((Object)"Q2/11"), (Object)9.03);
        defaultKeyedValues2.put((Comparable)((Object)"Q3/11"), (Object)9.72);
        defaultKeyedValues2.put((Comparable)((Object)"Q4/11"), (Object)10.58);
        defaultKeyedValues2.put((Comparable)((Object)"Q1/12"), (Object)10.65);
        defaultKeyedValues2.put((Comparable)((Object)"Q2/12"), (Object)12.214);
        defaultKeyedValues2.put((Comparable)((Object)"Q3/12"), (Object)14.101);
        defaultKeyedValues2.put((Comparable)((Object)"Q4/12"), (Object)14.419);
        defaultKeyedValues2.put((Comparable)((Object)"Q1/13"), (Object)13.969);
        defaultKeyedValues2.put((Comparable)((Object)"Q2/13"), (Object)14.105);
        defaultKeyedValues2.put((Comparable)((Object)"Q3/13"), (Object)14.893);
        defaultKeyedValues2.put((Comparable)((Object)"Q4/13"), (Object)16.858);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Google"), (KeyedValues)defaultKeyedValues2);
        DefaultKeyedValues defaultKeyedValues3 = new DefaultKeyedValues();
        defaultKeyedValues3.put((Comparable)((Object)"Q2/11"), (Object)17.37);
        defaultKeyedValues3.put((Comparable)((Object)"Q3/11"), (Object)17.37);
        defaultKeyedValues3.put((Comparable)((Object)"Q4/11"), (Object)20.89);
        defaultKeyedValues3.put((Comparable)((Object)"Q1/12"), (Object)17.41);
        defaultKeyedValues3.put((Comparable)((Object)"Q2/12"), (Object)18.06);
        defaultKeyedValues3.put((Comparable)((Object)"Q3/12"), (Object)16.008);
        defaultKeyedValues3.put((Comparable)((Object)"Q4/12"), (Object)21.456);
        defaultKeyedValues3.put((Comparable)((Object)"Q1/13"), (Object)20.489);
        defaultKeyedValues3.put((Comparable)((Object)"Q2/13"), (Object)19.896);
        defaultKeyedValues3.put((Comparable)((Object)"Q3/13"), (Object)18.529);
        defaultKeyedValues3.put((Comparable)((Object)"Q4/13"), (Object)24.519);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Microsoft"), (KeyedValues)defaultKeyedValues3);
        DefaultKeyedValues defaultKeyedValues4 = new DefaultKeyedValues();
        defaultKeyedValues4.put((Comparable)((Object)"Q2/11"), (Object)28.57);
        defaultKeyedValues4.put((Comparable)((Object)"Q3/11"), (Object)28.27);
        defaultKeyedValues4.put((Comparable)((Object)"Q4/11"), (Object)46.33);
        defaultKeyedValues4.put((Comparable)((Object)"Q1/12"), (Object)39.2);
        defaultKeyedValues4.put((Comparable)((Object)"Q2/12"), (Object)35.0);
        defaultKeyedValues4.put((Comparable)((Object)"Q3/12"), (Object)36.0);
        defaultKeyedValues4.put((Comparable)((Object)"Q4/12"), (Object)54.5);
        defaultKeyedValues4.put((Comparable)((Object)"Q1/13"), (Object)43.6);
        defaultKeyedValues4.put((Comparable)((Object)"Q2/13"), (Object)35.323);
        defaultKeyedValues4.put((Comparable)((Object)"Q3/13"), (Object)37.5);
        defaultKeyedValues4.put((Comparable)((Object)"Q4/13"), (Object)57.594);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Apple"), (KeyedValues)defaultKeyedValues4);
        return standardCategoryDataset3D;
    }

    static Chart3D createBarChart(String string) {
        CategoryDataset3D categoryDataset3D = SVGDemo1.createBarChartDataset();
        Chart3D chart3D = Chart3DFactory.createBarChart((String)"Quarterly Revenues", (String)"For some large IT companies", (CategoryDataset3D)categoryDataset3D, null, (String)"Quarter", (String)"$billion Revenues");
        chart3D.setID(string);
        chart3D.setChartBoxColor(new Color(255, 255, 255, 127));
        chart3D.setLegendAnchor(LegendAnchor.BOTTOM_RIGHT);
        CategoryPlot3D categoryPlot3D = (CategoryPlot3D)chart3D.getPlot();
        categoryPlot3D.setGridlinePaintForValues((Paint)Color.BLACK);
        StandardCategoryAxis3D standardCategoryAxis3D = (StandardCategoryAxis3D)categoryPlot3D.getRowAxis();
        CategoryMarker categoryMarker = new CategoryMarker((Comparable)((Object)"Apple"));
        standardCategoryAxis3D.setMarker("Apple", categoryMarker);
        StandardCategoryAxis3D standardCategoryAxis3D2 = (StandardCategoryAxis3D)categoryPlot3D.getColumnAxis();
        CategoryMarker categoryMarker2 = new CategoryMarker((Comparable)((Object)"Q4/12"));
        standardCategoryAxis3D2.setMarker("Q4/12", categoryMarker2);
        chart3D.getViewPoint().setRho(1.3 * chart3D.getViewPoint().getRho());
        return chart3D;
    }

    private static XYZDataset createScatterDataset(Comparable<?> comparable, Comparable<?> comparable2, Comparable<?> comparable3) {
        KeyedValues3D keyedValues3D;
        InputStreamReader inputStreamReader = new InputStreamReader(SVGDemo1.class.getResourceAsStream("iris.txt"));
        try {
            keyedValues3D = JSONUtils.readKeyedValues3D((Reader)inputStreamReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return DataUtils.extractXYZDatasetFromColumns((KeyedValues3D)keyedValues3D, comparable, comparable2, comparable3);
    }

    static Chart3D createScatterChart(String string) {
        XYZDataset xYZDataset = SVGDemo1.createScatterDataset("sepal length", "sepal width", "petal length");
        Chart3D chart3D = Chart3DFactory.createScatterChart((String)"Iris Dataset", null, (XYZDataset)xYZDataset, (String)"Sepal Length", (String)"Sepal Width", (String)"Petal Length");
        chart3D.setID(string);
        chart3D.setLegendAnchor(LegendAnchor.BOTTOM_LEFT);
        chart3D.setLegendOrientation(Orientation.VERTICAL);
        XYZPlot xYZPlot = (XYZPlot)chart3D.getPlot();
        NumberAxis3D numberAxis3D = (NumberAxis3D)xYZPlot.getYAxis();
        RangeMarker rangeMarker = new RangeMarker(3.5, 4.0);
        numberAxis3D.setMarker("M1", (ValueMarker)rangeMarker);
        ScatterXYZRenderer scatterXYZRenderer = (ScatterXYZRenderer)xYZPlot.getRenderer();
        scatterXYZRenderer.setSize(0.15);
        chart3D.getViewPoint().panLeftRight(0.2617993877991494);
        chart3D.getViewPoint().roll(0.2617993877991494);
        chart3D.getViewPoint().setRho(1.6 * chart3D.getViewPoint().getRho());
        return chart3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("SVGDemo1.html");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("<!DOCTYPE html>\n");
            bufferedWriter.write("<html>\n");
            bufferedWriter.write("<head>\n");
            bufferedWriter.write("<title>SVG Demo 1</title>\n");
            bufferedWriter.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n");
            bufferedWriter.write("<script src=\"lib/opentip-native.js\"></script>");
            bufferedWriter.write("<link href=\"css/opentip.css\" rel=\"stylesheet\" type=\"text/css\" />");
            bufferedWriter.write("<script src=\"lib/orsoncharts.js\"></script>");
            bufferedWriter.write("</head>\n");
            bufferedWriter.write("<body>\n");
            bufferedWriter.write("<h1>SVG Chart Demo</h1>\n");
            bufferedWriter.write("<p>Click on an item in the chart or just hover and look at the tooltip (the ");
            bufferedWriter.write("reference is a string in JSON format that should contain enough information to ");
            bufferedWriter.write("identify the chart element):</p>\n");
            bufferedWriter.write("  <script type=\"application/javascript\">\n");
            bufferedWriter.write("    function pieChartData() {\n");
            bufferedWriter.write("      return " + JSONUtils.writeKeyedValues((KeyedValues)SVGDemo1.createPieChartDataset()) + "\n");
            bufferedWriter.write("    }\n");
            bufferedWriter.write("  </script>\n");
            bufferedWriter.write("  <script type=\"application/javascript\">\n");
            bufferedWriter.write("    function barChartData() {\n");
            bufferedWriter.write("      return " + JSONUtils.writeKeyedValues3D((KeyedValues3D)SVGDemo1.createBarChartDataset()) + "\n");
            bufferedWriter.write("    }\n");
            bufferedWriter.write("  </script>\n");
            bufferedWriter.write("  <script type=\"application/javascript\">\n");
            bufferedWriter.write("    function scatterChartData() {\n");
            XYZDataset xYZDataset = SVGDemo1.createScatterDataset("sepal length", "sepal width", "petal length");
            bufferedWriter.write("      return " + JSONUtils.writeXYZDataset((XYZDataset)xYZDataset) + "\n");
            bufferedWriter.write("    }\n");
            bufferedWriter.write("  </script>\n");
            bufferedWriter.write("  <script type=\"application/javascript\">\n");
            bufferedWriter.write("    // wait until all the resources are loaded\n");
            bufferedWriter.write("    window.addEventListener(\"load\", initialise, false);\n");
            bufferedWriter.write("    function initialise() {\n");
            bufferedWriter.write("      orsoncharts.pieDataset = new orsoncharts.KeyedValuesDataset();\n");
            bufferedWriter.write("      orsoncharts.pieDataset.data = pieChartData();\n");
            bufferedWriter.write("      orsoncharts.pieLabelGenerator = new orsoncharts.KeyedValueLabels();\n");
            bufferedWriter.write("      orsoncharts.pieLabelGenerator.valueDP = 0;\n");
            bufferedWriter.write("      orsoncharts.pieLabelGenerator.format = \"{K} = NZ${V} million\";\n");
            bufferedWriter.write("      orsoncharts.barDataset = new orsoncharts.KeyedValues3DDataset();\n");
            bufferedWriter.write("      orsoncharts.barDataset.data = barChartData();\n");
            bufferedWriter.write("      orsoncharts.barLabelGenerator = new orsoncharts.KeyedValue3DLabels();\n");
            bufferedWriter.write("      orsoncharts.barLabelGenerator.format = \"{R}, {C} = US${V} billion\";\n");
            bufferedWriter.write("      orsoncharts.scatterDataset = new orsoncharts.XYZDataset();\n");
            bufferedWriter.write("      orsoncharts.scatterDataset.data.series = scatterChartData();\n");
            bufferedWriter.write("      orsoncharts.scatterLabelGenerator = new orsoncharts.XYZLabels();\n");
            bufferedWriter.write("      orsoncharts.scatterLabelGenerator.format = \"{S} = ({X}, {Y}, {Z})\";\n");
            bufferedWriter.write("      var pieSVG = document.getElementById(\"PieChart1\");\n");
            bufferedWriter.write("      pieSVG.onmouseover = handleMouseOver;\n");
            bufferedWriter.write("      pieSVG.onclick = handleClick;\n");
            bufferedWriter.write("      var barSVG = document.getElementById(\"BarChart1\");\n");
            bufferedWriter.write("      barSVG.onmouseover = handleMouseOver;\n");
            bufferedWriter.write("      barSVG.onclick = handleClick;\n");
            bufferedWriter.write("      var scatterSVG = document.getElementById(\"ScatterChart1\");\n");
            bufferedWriter.write("      scatterSVG.onmouseover = handleMouseOver;\n");
            bufferedWriter.write("      scatterSVG.onclick = handleClick;\n");
            bufferedWriter.write("    }\n");
            bufferedWriter.write("    function handleClick(evt) {\n");
            bufferedWriter.write("      var element = evt.target;\n");
            bufferedWriter.write("      var ref = orsoncharts.Utils.findChartRef(element);\n");
            bufferedWriter.write("      var chartId = orsoncharts.Utils.findChartId(element);\n");
            bufferedWriter.write("      alert('You clicked on the item ' + ref + ' for the chart [' + chartId + ']');\n");
            bufferedWriter.write("    }\n");
            bufferedWriter.write("    function handleMouseOver(evt) {\n");
            bufferedWriter.write("      var element = evt.target;\n");
            bufferedWriter.write("      var ref = orsoncharts.Utils.findChartRef(element);\n");
            bufferedWriter.write("      var content;\n");
            bufferedWriter.write("      var chartId = orsoncharts.Utils.findChartId(element);\n");
            bufferedWriter.write("      if (ref != null && ref != 'ORSON_CHART_TOP_LEVEL') {\n");
            bufferedWriter.write("        var refObj = JSON.parse(ref);\n");
            bufferedWriter.write("        if (Opentip.tips.length < 1) {\n");
            bufferedWriter.write("          myOpentip = new Opentip(element, \"content\");\n");
            bufferedWriter.write("        } else {\n");
            bufferedWriter.write("          myOpentip = Opentip.tips[0];\n");
            bufferedWriter.write("        }\n");
            bufferedWriter.write("        myOpentip.target = element;\n");
            bufferedWriter.write("        if (chartId == \"PieChart1\") {\n");
            bufferedWriter.write("          if (refObj.hasOwnProperty(\"key\")) {\n");
            bufferedWriter.write("             var itemIndex = orsoncharts.pieDataset.indexOf(refObj.key);\n");
            bufferedWriter.write("             content = orsoncharts.pieLabelGenerator.itemLabel(orsoncharts.pieDataset, itemIndex);\n");
            bufferedWriter.write("          } else { content = ref; }\n");
            bufferedWriter.write("        } else if (chartId == \"BarChart1\") {\n");
            bufferedWriter.write("          if (!refObj.hasOwnProperty(\"type\")) {\n");
            bufferedWriter.write("            var seriesIndex = orsoncharts.barDataset.seriesIndex(refObj.seriesKey);\n");
            bufferedWriter.write("            var rowIndex = orsoncharts.barDataset.rowIndex(refObj.rowKey);\n");
            bufferedWriter.write("            var columnIndex = orsoncharts.barDataset.columnIndex(refObj.columnKey);\n");
            bufferedWriter.write("            content = orsoncharts.barLabelGenerator.itemLabel(orsoncharts.barDataset, seriesIndex, rowIndex, columnIndex);\n");
            bufferedWriter.write("          } else {\n");
            bufferedWriter.write("          content = ref + \" for bar chart.\";\n");
            bufferedWriter.write("          }\n");
            bufferedWriter.write("        } else if (chartId == \"ScatterChart1\") {\n");
            bufferedWriter.write("          if (!refObj.hasOwnProperty(\"type\")) {\n");
            bufferedWriter.write("            content = orsoncharts.scatterLabelGenerator.itemLabel(orsoncharts.scatterDataset, refObj.seriesKey, refObj.itemIndex);\n");
            bufferedWriter.write("          } else {\n");
            bufferedWriter.write("            content = ref + \" for scatter plot.\";\n");
            bufferedWriter.write("          }\n");
            bufferedWriter.write("        }\n");
            bufferedWriter.write("        myOpentip.setContent(content);\n");
            bufferedWriter.write("        myOpentip.reposition();\n");
            bufferedWriter.write("        myOpentip.show();\n");
            bufferedWriter.write("      }\n");
            bufferedWriter.write("    }\n");
            bufferedWriter.write("</script>\n");
            bufferedWriter.write("<p>\n");
            Chart3D chart3D = SVGDemo1.createPieChart("PieChart1");
            bufferedWriter.write(SVGDemo1.generateSVGForChart(chart3D, 600, 370, "defs1_") + "\n");
            bufferedWriter.write("</p>\n");
            bufferedWriter.write("<p>\n");
            Chart3D chart3D2 = SVGDemo1.createBarChart("BarChart1");
            bufferedWriter.write(SVGDemo1.generateSVGForChart(chart3D2, 600, 370, "defs2_") + "\n");
            bufferedWriter.write("</p>\n");
            bufferedWriter.write("<p>\n");
            Chart3D chart3D3 = SVGDemo1.createScatterChart("ScatterChart1");
            bufferedWriter.write(SVGDemo1.generateSVGForChart(chart3D3, 600, 370, "defs3_") + "\n");
            bufferedWriter.write("</p>\n");
            bufferedWriter.write("</body>\n");
            bufferedWriter.write("</html>\n");
            bufferedWriter.flush();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(SVGDemo1.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }
}

