/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.DemoPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;

public class ThermometerDemo1
extends ApplicationFrame {
    public ThermometerDemo1(String string) {
        super(string);
        JPanel jPanel = ThermometerDemo1.createDemoPanel();
        this.setContentPane(jPanel);
    }

    public static JPanel createDemoPanel() {
        return new ContentPanel();
    }

    public static void main(String[] stringArray) {
        ThermometerDemo1 thermometerDemo1 = new ThermometerDemo1("Thermometer Demo 1");
        thermometerDemo1.pack();
        thermometerDemo1.setVisible(true);
    }

    static class ContentPanel
    extends DemoPanel
    implements ChangeListener {
        JSlider slider = new JSlider(0, 200, 100);
        DefaultValueDataset dataset;

        public ContentPanel() {
            super(new BorderLayout());
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            this.slider.setMajorTickSpacing(25);
            this.slider.addChangeListener(this);
            this.add((Component)this.slider, "South");
            this.dataset = new DefaultValueDataset(this.slider.getValue());
            JFreeChart jFreeChart = ContentPanel.createChart(this.dataset);
            this.addChart(jFreeChart);
            this.add(new ChartPanel(jFreeChart));
        }

        private static JFreeChart createChart(ValueDataset valueDataset) {
            ThermometerPlot thermometerPlot = new ThermometerPlot(valueDataset);
            JFreeChart jFreeChart = new JFreeChart("Thermometer Demo 1", JFreeChart.DEFAULT_TITLE_FONT, thermometerPlot, true);
            thermometerPlot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            thermometerPlot.setPadding(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
            thermometerPlot.setThermometerStroke(new BasicStroke(2.0f));
            thermometerPlot.setThermometerPaint(Color.lightGray);
            thermometerPlot.setUnits(1);
            thermometerPlot.setGap(3);
            thermometerPlot.setRange(0.0, 200.0);
            thermometerPlot.setSubrange(0, 0.0, 85.0);
            thermometerPlot.setSubrangePaint(0, Color.red);
            thermometerPlot.setSubrange(1, 85.0, 125.0);
            thermometerPlot.setSubrangePaint(1, Color.green);
            thermometerPlot.setSubrange(2, 125.0, 200.0);
            thermometerPlot.setSubrangePaint(2, Color.red);
            ChartUtilities.applyCurrentTheme(jFreeChart);
            return jFreeChart;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.dataset.setValue(new Integer(this.slider.getValue()));
        }
    }
}

