// Convolution.cpp
//
//
// Authors:  
//	Template:	George Chaltas, Intel Corporation, 2011
//				Adam Goldman, Intel Corporation, 2013				- Creation of Convolution.cpp


#include <Windows.h>
#include <stdio.h>
#include "vpViewset.h"

extern "C" int vpInitTest(vpState *state, int testNumber, const char *optionString )
{
	// 	DEBUG_MSG("Entered vpInitTest()\n");
	(state->vpFuncs.logMessage)( state, "Entered vpInitTest in viewset" );
	if (optionString) {
		(state->vpFuncs.logMessage)( state, "optionString is set" );
		(state->vpFuncs.logMessage)( state, optionString );
	}
	// Sample allocation of local data

	if (testNumber == 0) {
		state->pTestPrivate = (void *) malloc(4096);
	}
	if (state->pTestPrivate)
		return 1;
	else
		return 0;
}

extern "C" int vpExecTest( vpState *state, vpTestState *pTestState, int testNumber, int startFrame )
{
	char msgBuffer[128];

	SYSTEM_INFO sysinfo;
	GetSystemInfo( &sysinfo );

	int numCPU = sysinfo.dwNumberOfProcessors;
	
	FILE* CON_LOG = fopen("..\\..\\results\\Convolution\\Convolution.out", "w+");
	if( CON_LOG == NULL )
	{
		fprintf(stderr, "Error: Could not create/open log file.\n");
		return 0;
	}
	
	// vpTestState *ptestState= (vpTestState *) state->pTestPrivate;
	
	//DEBUG_MSG("Entered vpExecTest()\n");
	sprintf( msgBuffer, "entered vpExecTest, test %d", testNumber );
	(state->vpFuncs.logMessage)( state, msgBuffer );

	char command[50];
	if(testNumber == 1)
	{
		sprintf(command, "exe\\Convolution.exe -x 20000 -y 20000 -f 100 -i 1");
		printf("%s\n", command);
		if( system(command) == 0)
		{
			fprintf(CON_LOG, "Successful execution of Convolution.exe!\n");
			sprintf( msgBuffer, "Successful execution of Convolution.exe!\n");
			(state->vpFuncs.logMessage)( state, msgBuffer );
		}
		else
		{
			fprintf(CON_LOG, "Unsuccessful execution of Convolution.exe!\n");
			sprintf( msgBuffer, "Unsuccessful execution of Convolution.exe!\n");
			(state->vpFuncs.logMessage)( state, msgBuffer );
		}
	}
	
	if( CON_LOG != NULL )
	{
		if( fclose(CON_LOG) )
		{
			fprintf(stderr,"Error: could not close log file.\n");
			return 0;
		}
	}

	if((state->vpFuncs.frameEnd)(state, pTestState))
		return 0;
	return 1;
}


extern "C" int vpCloseTest( vpState *state, int testNumber )
{
	// DEBUG_MSG("Entered vpCloseTest()\n");
	(state->vpFuncs.logMessage)( state, "Entered vpCloseTest in viewset" );

	if (testNumber == 0 && state->pTestPrivate != NULL) {
		free(state->pTestPrivate);
		state->pTestPrivate = NULL;
	}
	return 1;
}

extern "C" __declspec(dllexport) int vpGetTestInfo(vpInfo *info, int testNumber)
{
	//	DEBUG_MSG("Entered vpGetTestInfo()\n");
	//	(state->vpFuncs.logMessage)( state, "Entered vpGetTestInfo in viewset" );

	if (testNumber == 0) {
		// fill in the vpInfo data structure

		info->version = VP_INFO_VERSION;
		info->extension = NULL;
		info->size = sizeof( vpInfo );

		// This viewset spawns no threads
		info->maxSpawnedThreads = 0; 

		// There are 3 tests in this viewset
		info->numTests=1;

		// This viewset makes no graphics API calls
		info->graphicsAPImask = VP_M_API_NONE;

		// call vector
		info->callVector.closeTest = vpCloseTest;
		info->callVector.initTest = vpInitTest;
		info->callVector.execTest = vpExecTest;
		info->callVector.getTestInfo = vpGetTestInfo;
	}
	return 1;
}