/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "surfMesh.H"
#include "globalMeshData.H"
#include "demandDrivenData.H"

// * * * * * * * * * * * * * Private Member Functions  * * * * * * * * * * * //

void Foam::surfMesh::removeZones()
{
    if (debug)
    {
        Info<< "void surfMesh::removeZones(): "
            << "Removing surface zones."
            << endl;
    }

    // Remove the surface zones
    storedZones().clear();

    clearOut();
}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::surfMesh::clearGeom()
{
    if (debug)
    {
        Info<< "void surfMesh::clearGeom() : "
            << "clearing geometric data"
            << endl;
    }

    MeshReference::clearGeom();
}


void Foam::surfMesh::clearAddressing()
{
    if (debug)
    {
        Info<< "void surfMesh::clearAddressing() : "
            << "clearing topology"
            << endl;
    }

    MeshReference::clearPatchMeshAddr();
}


void Foam::surfMesh::clearOut()
{
    clearGeom();
    clearAddressing();
}


// ************************************************************************* //
