/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011-2012 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "makeBasicRhoThermo.H"

#include "perfectGas.H"
#include "isobaricPerfectGas.H"
#include "incompressible.H"

#include "hConstThermo.H"
#include "janafThermo.H"
#include "specieThermo.H"

#include "constTransport.H"
#include "sutherlandTransport.H"

#include "icoPolynomial.H"
#include "hPolynomialThermo.H"
#include "polynomialTransport.H"

#include "hRhoThermo.H"
#include "pureMixture.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/* * * * * * * * * * * * * * * private static data * * * * * * * * * * * * * */

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    constTransport,
    hConstThermo,
    perfectGas
);

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    sutherlandTransport,
    hConstThermo,
    perfectGas
);

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    sutherlandTransport,
    janafThermo,
    perfectGas
);

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    constTransport,
    hConstThermo,
    incompressible
);

makeBasicRhoPolyThermo
(
    hRhoThermo,
    pureMixture,
    3
);

makeBasicRhoPolyThermo
(
    hRhoThermo,
    pureMixture,
    8
);

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    constTransport,
    hConstThermo,
    isobaricPerfectGas
);

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    sutherlandTransport,
    hConstThermo,
    isobaricPerfectGas
);

makeBasicRhoThermo
(
    hRhoThermo,
    pureMixture,
    sutherlandTransport,
    janafThermo,
    isobaricPerfectGas
);

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
