/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011-2012 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Typedefs
    Foam::thermoPhysicsTypes

Description
    Type definitions for thermo-physics models

\*---------------------------------------------------------------------------*/

#ifndef thermoPhysicsTypes_H
#define thermoPhysicsTypes_H

#include "perfectGas.H"
#include "isobaricPerfectGas.H"
#include "hConstThermo.H"
#include "janafThermo.H"
#include "specieThermo.H"
#include "sutherlandTransport.H"
#include "constTransport.H"

#include "icoPolynomial.H"
#include "hPolynomialThermo.H"
#include "polynomialTransport.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    typedef constTransport<specieThermo<hConstThermo<perfectGas> > >
        constGasThermoPhysics;

    typedef sutherlandTransport<specieThermo<janafThermo<perfectGas> > >
        gasThermoPhysics;

    typedef constTransport<specieThermo<hConstThermo<isobaricPerfectGas> > >
        constIsobaricGasThermoPhysics;

    typedef sutherlandTransport<specieThermo<janafThermo<isobaricPerfectGas> > >
        isobaricGasThermoPhysics;

    typedef polynomialTransport
        <
            specieThermo
            <
                hPolynomialThermo
                <
                    icoPolynomial<8>,
                    8
                >
            >,
            8
        >
        icoPoly8ThermoPhysics;
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
