!
!     CalculiX - A 3-dimensional finite element program
!              Copyright (C) 1998-2011 Guido Dhondt
!
!     This program is free software; you can redistribute it and/or
!     modify it under the terms of the GNU General Public License as
!     published by the Free Software Foundation(version 2);
!     
!
!     This program is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of 
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with this program; if not, write to the Free Software
!     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!
      subroutine complexfrequencies(inpc,textpart,nmethod,
     &  mei,iperturb,istep,istat,n,iline,ipol,inl,
     &  ipoinp,inp,ithermal,xboun,nboun,ipoinpc,mcs,cs)
!
!     reading the input deck: *COMPLEX FREQUENCY
!
      implicit none
!
      logical cyclicsymmetry
!
      character*1 inpc(*)
      character*132 textpart(16)
!
      integer nmethod,mei(4),istep,istat,iperturb(2),i,nboun,
     &  n,key,iline,ipol,inl,ipoinp(2,*),inp(3,*),nev,ithermal,
     &  ipoinpc(0:*),mcs
!
      real*8 xboun(*),cs(17,*)
!
      mei(4)=0
!
      if(istep.lt.1) then
         write(*,*) '*ERROR reading *COMPLEX FREQUENCY:'
         write(*,*) '       *COMPLEX FREQUENCY can only be used'
         write(*,*) '       within a STEP'
         stop
      endif
!
!     no heat transfer analysis
!
      if(ithermal.gt.1) then
         ithermal=1
      endif
!
!     check for cyclic symmetry
!
      if((mcs.ne.0).and.(cs(2,1).ge.0.d0)) then
         cyclicsymmetry=.true.
      else
         cyclicsymmetry=.false.
      endif
!
      do i=2,n
         if(textpart(i)(1:14).eq.'CYCLICSYMMETRY') then
            cyclicsymmetry=.true.
         else
            write(*,*) 
     &                 '*WARNING reading *COMPLEX FREQUENCY:'
            write(*,*) '         parameter not recognized:'
            write(*,*) '         ',
     &                 textpart(i)(1:index(textpart(i),' ')-1)
            call inputwarning(inpc,ipoinpc,iline)
         endif
      enddo
!
      nmethod=6
      if(iperturb(1).gt.1) iperturb(1)=0
      iperturb(2)=0
!
      call getnewline(inpc,textpart,istat,n,key,iline,ipol,inl,
     &     ipoinp,inp,ipoinpc)
      if((istat.lt.0).or.(key.eq.1)) then
         write(*,*) '*ERROR reading *COMPLEX FREQUENCY:'
         write(*,*) '       definition not complete'
         write(*,*) '  '
         call inputerror(inpc,ipoinpc,iline)
         stop
      endif
      read(textpart(1)(1:10),'(i10)',iostat=istat) nev
      if(istat.gt.0) call inputerror(inpc,ipoinpc,iline)
      if(nev.le.0) then
         write(*,*) '*ERROR reading *COMPLEX FREQUENCY:'
         write(*,*) '       less than 1 eigenvalue requested'
         stop
      endif
!
      mei(1)=nev
!
!     removing nonzero boundary conditions
!
      do i=1,nboun
         xboun(i)=0.d0
      enddo
!
!     correction for cyclic symmetric structures:
!     if the present step was not preceded by a frequency step
!     no nodal diameter has been selected. To make sure that
!     mastructcs is called instead of mastruct a fictitious
!     minimum nodal diameter is stored
!
      if((cyclicsymmetry).and.(mcs.ne.0).and.(cs(2,1)<0.d0)) 
     &       cs(2,1)=0.d0
!
      call getnewline(inpc,textpart,istat,n,key,iline,ipol,inl,
     &     ipoinp,inp,ipoinpc)
!
      return
      end

