#
# Try to find the FreeImage library and include path.
# Once done this will define
#
# FREEIMAGE_FOUND
# FREEIMAGE_INCLUDE_DIR
# FREEIMAGE_LIBRARIES
# 

# Lookup user provide path first
SET(FREEIMAGE_INC_SUFFIXES include/freeimage include Include Headers Dist Source)
FIND_PATH(FREEIMAGE_INCLUDE_DIR
	NAMES FreeImage.h freeimage.h
	PATHS
	${FREEIMAGE_ROOT}
	PATH_SUFFIXES ${FREEIMAGE_INC_SUFFIXES}
	DOC "The directory where FreeImage.h resides")
FIND_PATH(FREEIMAGE_INCLUDE_DIR
	NAMES FreeImage.h freeimage.h
	PATHS /usr /usr/local /sw /opt/local
	PATH_SUFFIXES ${FREEIMAGE_INC_SUFFIXES}
	DOC "The directory where FreeImage.h resides")
SET(FREEIMAGE_NAMES_REL FreeImage freeimage)
SET(FREEIMAGE_LIB_SUFFIXES lib64 lib Lib lib/freeimage Libs Dist Release Debug)
SET(FREEIMAGE_LIB_SUFFIXES_REL)
SET(FREEIMAGE_LIB_SUFFIXES_DBG)
FOREACH(i ${FREEIMAGE_LIB_SUFFIXES})
	SET(FREEIMAGE_LIB_SUFFIXES_REL ${FREEIMAGE_LIB_SUFFIXES_REL}
		"${i}" "${i}/release" "${i}/relwithdebinfo" "${i}/minsizerel" "${i}/dist")
	SET(FREEIMAGE_LIB_SUFFIXES_DBG ${FREEIMAGE_LIB_SUFFIXES_DBG}
		"${i}" "${i}/debug" "${i}/dist")
ENDFOREACH(i)
SET(FREEIMAGE_NAMES_DBG)
FOREACH(i ${FREEIMAGE_NAMES_REL})
	SET(FREEIMAGE_NAMES_DBG ${FREEIMAGE_NAMES_DBG} "${i}d" "${i}D" "${i}_d" "${i}_D" "${i}_debug")
ENDFOREACH(i)
FIND_LIBRARY(FREEIMAGE_LIBRARY_REL
	NAMES ${FREEIMAGE_NAMES_REL}
	PATHS "${FREEIMAGE_ROOT}"
	PATH_SUFFIXES ${FREEIMAGE_LIB_SUFFIXES_REL}
	NO_DEFAULT_PATH
	DOC "The FreeImage release library"
)
FIND_LIBRARY(FREEIMAGE_LIBRARY_REL
	NAMES ${FREEIMAGE_NAMES_REL}
	PATHS /usr/local /usr /sw /opt/local /opt/csw /opt
	PATH_SUFFIXES ${FREEIMAGE_LIB_SUFFIXES_REL}
	DOC "The FreeImage release library"
)
FIND_LIBRARY(FREEIMAGE_LIBRARY_DBG
	NAMES ${FREEIMAGE_NAMES_DBG}
	PATHS "${FREEIMAGE_ROOT}"
	PATH_SUFFIXES ${FREEIMAGE_LIB_SUFFIXES_DBG}
	NO_DEFAULT_PATH
	DOC "The FreeImage debug library"
)
FIND_LIBRARY(FREEIMAGE_LIBRARY_DBG
	NAMES ${FREEIMAGE_NAMES_DBG}
	PATHS /usr/local /usr /sw /opt/local /opt/csw /opt
	PATH_SUFFIXES ${FREEIMAGE_LIB_SUFFIXES_DBG}
	DOC "The FreeImage debug library"
)
IF (FREEIMAGE_LIBRARY_REL AND FREEIMAGE_LIBRARY_DBG)
	SET(FREEIMAGE_LIBRARIES
		optimized ${FREEIMAGE_LIBRARY_REL}
		debug ${FREEIMAGE_LIBRARY_DBG})
ELSEIF (FREEIMAGE_LIBRARY_REL)
	SET(FREEIMAGE_LIBRARIES ${FREEIMAGE_LIBRARY_REL})
ELSEIF (FREEIMAGE_LIBRARY_DBG)
	SET(FREEIMAGE_LIBRARIES ${FREEIMAGE_LIBRARY_DBG})
ENDIF (FREEIMAGE_LIBRARY_REL AND FREEIMAGE_LIBRARY_DBG)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(FREEIMAGE  DEFAULT_MSG  FREEIMAGE_LIBRARIES FREEIMAGE_INCLUDE_DIR)

MARK_AS_ADVANCED(FREEIMAGE_LIBRARY FREEIMAGE_LIBRARIES FREEIMAGE_INCLUDE_PATH)
