#    Sample Scripts 
#
#    These scripts are distributed in the hope that they will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
#
#!/bin/sh -x
. ./env.sh

# create jdbc connection pool for MySQL
#$J2EE_HOME/bin/asadmin create-jdbc-connection-pool -u $ADMIN_USER --passwordfile $PASSFILE -H $JAS_HOST -p $ADMIN_PORT --datasourceclassname com.mysql.jdbc.jdbc2.optional.MysqlDataSource --restype javax.sql.DataSource $CONNECTION_POOL

# create jdbc connection pool for PostgreSQL
if [ ! -f "$JDBC_CLASSPATH" ]; then
  echo $JDBC_CLASSPATH
  echo "JDBC_CLASSPATH in SPECjAppServer2004/config/glassfish.env should point to postgresql jdbc jar. Please rerun $0 after fixing this issue"
  exit
fi
cp $JDBC_CLASSPATH $J2EE_HOME/lib
  
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE -H $JAS_HOST -p $ADMIN_PORT create-jdbc-connection-pool --datasourceclassname org.postgresql.ds.PGSimpleDataSource --restype javax.sql.DataSource $CONNECTION_POOL

$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.serverName=$DB_HOST 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.portNumber=$DBPORT 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.DatabaseName=$DBNAME 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.User=$DBUSER 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.Password=$DBPASS 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.autoReconnect="true" 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.statement_cache="true" 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.statement_cache_size="512" 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.prepareThreshold="1" 
$J2EE_HOME/bin/asadmin -u $ADMIN_USER --passwordfile $PASSFILE set domain.resources.jdbc-connection-pool.$CONNECTION_POOL.property.ssl="false" 

# create jdbc resource with JNDI lookup name
$J2EE_HOME/bin/asadmin --user $ADMIN_USER --passwordfile $PASSFILE --host $JAS_HOST --port $ADMIN_PORT create-jdbc-resource --connectionpoolid $CONNECTION_POOL jdbc/SPECDB

