#!/bin/sh
#
#  collect_data_esxi_20130417.sh
#
#  Runs on primecontroller client and uses /opt/SPECvirt/Control.config
#  to determine number of tiles for data collection.  The script attempts
#  to collect configuration and tuning information on the host and the VMs.
#  This data will confirm and suppliment the information in the FDR.
#
#  Note: 
#  This script is based on a set of SPECvirt_sc2013  Example VMs which are
#  RHEL6 based and used Apache Httpd, Dovecot, Glassfish, Tomcat, and Postgres
#  for the application software.  The exact paths and file names may differ
#  between environments, so you MUST check and update the paths and file names 
#  to match your environment and applications used.  Please collect any files
#  that could be used to confirm info in the full disclosure report (FDR) and 
#  support reproducing the test.
#
#  The layout of the directory tree is from the specified top
#  such as /tmp/data-collection is described below the svconfig_VSP.sh
#  script uses the "very short pathnames" shown in parenthesis:
#
#  Physical_Configuration (PHYS)
#      Clients
#          client#
#              {Collected files for the guest client's configuration}
#          wclient#
#              {Collected files for the guest web client's configuration}
#          VMdata   
#              {Collected files for client host/hypervisor configuration}
#      System_Under_Test (SUT)
#          {Collected file for host/hypervisor configuration}
#  Virtual_Configuration (VIRT)
#      tile#/{appserver, dbserver, batchserver, infraserver, mailserver, or webserver}
#          Software_Configuration (SOFTW)
#              {Collected files for application software}
#          VM_Configuration (VM)
#               {Collected files for VM and guest OS Configuration}
#
#  History:
#
#  09/23/2010 Beta 1 release - psmith    - initial SPECvirt_sc2010 release
#  09/30/2010 Beta 2 release - psmith 	 - fix weddbserver/SOFTW collection
#  10/04/2010 Beta 3 release - psmith 	 - fix missing collection items;
#                                      	   preserve timestamps
#  10/05/2010 Beta 4 release - psmith 	 - more bug fixes and cleanup tmp dirs
#  02/06/2012 Beta 5 release - dschmidt  - updated to handle ESXi 5 scripts
#  04/17/2013 Beta A1 release - dschmidt - updated for SPECvirt_sc2013
#
###set -x 

########################################################
#  Edit variables below to match your environment
########################################################
#    Host and Client Server Names
myserver="sut"
myclient="dl360g7-virt-client"
########################################################
#    Host and Client Server Data Collection Scripts
hostscript="/vmfs/volumes/SSD-Store1/reporter/vSphere-get-config_2013-0426.sh"
clientscript="/vmfs/volumes/p2k01-virtnext01/reporter/vSphere-get-config_2012-0206-dls.sh"
#clientscript="/vmfs/volumes/p2k01-virtnext01/reporter/vSphere-get-config_2013-0426.sh"

########################################################
#    Location of output of data host collection script 
#    (/vSphere-get-config.sh uses manually defined volume)
###hostscriptpath="/vmfs/volumes/LUN8/reporter"
hostscriptpath="/vmfs/volumes/SSD-Store1/reporter"
clientscriptpath="/vmfs/volumes/p2k01-virtnext01/reporter"
########################################################
#    Set basename for clients
client="client"
wclient="wclient"
########################################################
#    Setup Path to top of data-collection tree 
#    (save last version as .old)
top="/tmp/data-collection"

echo " "
echo "================================================"
echo "Script defaults to values below, if incorrect"
echo "cancel (control-C) within next 20 seconds and"
echo "edit script to correct."
echo "================================================"
echo " "
echo "Host Server Name or Alias: $myserver"
echo "Host Server Data Collection Script: $hostscript"
echo "Location of output of data host collection script: $hostscriptpath"
echo "Basename for clients: $client"
echo "Path to top of data-collection tree: $top"
echo " "
echo "================================================"
sleep 5

rm -rf $top.old
mv $top $top.old
mkdir $top
cd $top
########################################################


main() {

cd $top
date > Data-Collection-Start.txt

########################################################
# Run data collection script on host (hypervisor).
echo Running $hostscript on $myserver may take several minutes.

ssh $myserver $hostscript
ssh $myclient $clientscript

# Pull number of tiles from Control.config file
tiles="`grep "^NUM_TILES[[:space:]]*=[[:space:]]*"  /opt/SPECvirt/Control.config|grep = |cut -d \" \" -f 3`"
set -- $tiles
tiles=$1
echo Tile count = $tiles

buildDirTree $top

# Fill in directory tree

	cd $top/PHYS/SUT
        ssh $myserver "vdf" > vdf.txt
#        ssh $myserver "lspci" > lspci.txt
        ssh $myserver "chkconfig --list" > chkconfig.txt
#        ssh $myserver "ifconfig" > ifconfig.txt
        scp -p $myserver:/etc/vmware/esx.conf ./
        ssh $myserver "esxcfg-info --all -F perl > /tmp/esxcfg-info--all-Fperl.out 2> /dev/null"
        scp -p $myserver:/tmp/esxcfg-info--all-Fperl.out ./

        hscriptcmd="ls $hostscriptpath/*tgz|tail -1"
        hscriptname=`ssh $myserver $hscriptcmd`
        scp -p $myserver:/tmp/ResultsPath.txt ./
	HOSTFILESPATH=$(tail -1 ResultsPath.txt)
	VMSUPPORTPATH=$(sed -e '$!{h;d;}' -e x ResultsPath.txt)
	HOSTREPORTERDIR=$(dirname $VMSUPPORTPATH)
 	VMSUPPORTFILE=$(basename $VMSUPPORTPATH)		# Get zipfile name
   	HOSTFILES=$(basename $HOSTFILESPATH)
   	VMSUPPORTDIR=$(echo ${VMSUPPORTFILE%\.tgz})	# remove .tgz from end of zipfile name
	scp -p root@$myserver:"$VMSUPPORTPATH $HOSTFILESPATH" ./

        scp -p $myserver:$hscriptname ./
        tar -zxf $VMSUPPORTFILE
	rm -f $VMSUPPORTFILE
	cd $VMSUPPORTDIR
	#rm -rf vmfs/volumes/*/*/vmware-*.log var/run/log/*.[1-9].gz commands/*traverse*[0-9]
  	find . -type f -name dump-vmdk-rdm-info.sh*.txt 2> /dev/null | while read ORIG_FILENAME ; do # rename this file which often has error-producing long filename
      	mv $ORIG_FILENAME "$(dirname $ORIG_FILENAME)/dump-vmdk-rdm-info.sh.txt"
   	done
	cd ../
#        rm dl380p-gen8*.tgz
	
	cd $top/PHYS/Clients/VMdata
        ssh $myclient "vdf" > vdf.txt
        ssh $myclient "lspci" > lspci.txt
        ssh $myclient "chkconfig --list" > chkconfig.txt
        ssh $myclient "ifconfig" > ifconfig.txt
        scp -p $myclient:/etc/vmware/esx.conf ./
        ssh $myclient "esxcfg-info --all -F perl > /tmp/esxcfg-info--all-Fperl.out 2> /dev/null"
        scp -p $myclient:/tmp/esxcfg-info--all-Fperl.out ./
        hscriptcmd="ls $clientscriptpath/*tgz|tail -1"
        hscriptname=`ssh $myclient $hscriptcmd`
        scp -p $myclient:$hscriptname ./
        tar -zxf dl360-g7*.tgz
        rm dl360-g7*.tgz
	
##
##      Need to unpack and arrange data in the vSphere-get-config.sh tgz file
##

cd $top/PHYS
	cd $top/PHYS/Clients
for i in `seq 1 $tiles`;
    do
##
## app, mail, batch client data
##
	cd $top/PHYS/Clients/$client$i
	ssh $client$i "rm -rf /tmp/client-info; mkdir /tmp/client-info; mkdir /tmp/client-info/PHYS; mkdir /tmp/client-info/SW "
        ssh $client$i "cd /tmp/client-info/SW; chkconfig --list > chkconfig.txt"
        ssh $client$i "cd /tmp/client-info/PHYS; df > df.txt"
        ssh $client$i "cd /tmp/client-info/PHYS; ifconfig > ifconfig.txt"
        ssh $client$i "cd /tmp/client-info/PHYS; lspci > lspci.txt"
        ssh $client$i "cd /tmp/client-info/PHYS; mount > mount.txt"
        ssh $client$i "cd /tmp/client-info/SW; rpm -q -a > rpmpkgs.txt"
        ssh $client$i "cd /tmp/client-info/PHYS; mkdir proc"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/cpuinfo ./"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/devices ./"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/meminfo ./"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/modules ./"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/partitions ./"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/swaps ./"
        ssh $client$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/version ./"
        ssh $client$i "cd /tmp/client-info/SW; mkdir boot; mkdir boot/grub"
        ssh $client$i "cd /tmp/client-info/SW/boot/grub; cp -p /boot/grub/grub.conf ./"
        ssh $client$i "cd /tmp/client-info/SW; mkdir var; mkdir var/log"
        ssh $client$i "cd /tmp/client-info/SW/var/log; cp -p /var/log/dmesg ./"
        ssh $client$i "cd /tmp/client-info/SW; mkdir etc; mkdir etc/iproute2; mkdir etc/rc.d; mkdir etc/rc.d/init.d; mkdir etc/rc.d/rc3.d; mkdir etc/security"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/bashrc ./"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/fstab ./"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/hosts ./"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/inittab ./"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/nsswitch.conf ./"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/rc.local ./"
        ssh $client$i "cd /tmp/client-info/SW/etc; cp -p /etc/sysctl.conf ./"
        ssh $client$i "cd /tmp/client-info/SW/etc/iproute2; cp -p /etc/iproute2/* ./"
        ssh $client$i "cd /tmp/client-info/SW/etc/rc.d/init.d; cp -p /etc/rc.d/init.d/* ./"
        ssh $client$i "cd /tmp/client-info/SW/etc/rc.d/rc3.d; cp -p /etc/rc.d/rc3.d/* ./"
        ssh $client$i "cd /tmp/client-info/SW/etc/security; cp -p /etc/security/limits.conf ./"

        ssh $client$i "cd /tmp/client-info; tar cf - *|gzip > /tmp/client-info.tgz"
	cd $top/PHYS/Clients/$client$i
        scp -p $client$i:/tmp/client-info.tgz  ./
	tar -zxf ./client-info.tgz
        rm ./client-info.tgz
##
## web client data
##
  
        cd $top/PHYS/Clients/$wclient$i
        ssh $wclient$i "rm -rf /tmp/client-info; mkdir /tmp/client-info; mkdir /tmp/client-info/PHYS; mkdir /tmp/client-info/SW "
        ssh $wclient$i "cd /tmp/client-info/SW; chkconfig --list > chkconfig.txt"
        ssh $wclient$i "cd /tmp/client-info/PHYS; df > df.txt"
        ssh $wclient$i "cd /tmp/client-info/PHYS; ifconfig > ifconfig.txt"
        ssh $wclient$i "cd /tmp/client-info/PHYS; lspci > lspci.txt"
        ssh $wclient$i "cd /tmp/client-info/PHYS; mount > mount.txt"
        ssh $wclient$i "cd /tmp/client-info/SW; rpm -q -a > rpmpkgs.txt"
        ssh $wclient$i "cd /tmp/client-info/PHYS; mkdir proc"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/cpuinfo ./"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/devices ./"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/meminfo ./"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/modules ./"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/partitions ./"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/swaps ./"
        ssh $wclient$i "cd /tmp/client-info/PHYS/proc; cp -p /proc/version ./"
        ssh $wclient$i "cd /tmp/client-info/SW; mkdir boot; mkdir boot/grub"
        ssh $wclient$i "cd /tmp/client-info/SW/boot/grub; cp -p /boot/grub/grub.conf ./"
        ssh $wclient$i "cd /tmp/client-info/SW; mkdir var; mkdir var/log"
        ssh $wclient$i "cd /tmp/client-info/SW/var/log; cp -p /var/log/dmesg ./"
        ssh $wclient$i "cd /tmp/client-info/SW; mkdir etc; mkdir etc/iproute2; mkdir etc/rc.d; mkdir etc/rc.d/init.d; mkdir etc/rc.d/rc3.d; mkdir etc/security"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/bashrc ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/fstab ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/hosts ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/inittab ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/nsswitch.conf ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/rc.local ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc; cp -p /etc/sysctl.conf ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc/iproute2; cp -p /etc/iproute2/* ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc/rc.d/init.d; cp -p /etc/rc.d/init.d/* ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc/rc.d/rc3.d; cp -p /etc/rc.d/rc3.d/* ./"
        ssh $wclient$i "cd /tmp/client-info/SW/etc/security; cp -p /etc/security/limits.conf ./"

        ssh $wclient$i "cd /tmp/client-info; tar cf - *|gzip > /tmp/client-info.tgz"
        cd $top/PHYS/Clients/$wclient$i
        scp -p $wclient$i:/tmp/client-info.tgz  ./
        tar -zxf ./client-info.tgz
        rm ./client-info.tgz

    done

        


cd $top/VIRT
for i in `seq 1 $tiles`;
    do
####### Collect data on appserver VMs #######
	cd $top/VIRT/tile$i/appserver/SOFTW
	ssh appserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info"
	ssh appserver$i "cd /tmp/software-info; java -version 2> javaVersion.out"
        scp -p appserver$i:/tmp/software-info/javaVersion.out ./

        # copy /opt/glassfish/domains/spec2004-1 tree and remove cruft
        ssh appserver$i "cd /opt/glassfish/glassfish/domains; cp -pr spec2004-1/config /tmp/software-info/spec2004-1"
        ssh appserver$i "cd /opt/glassfish/glassfish/domains; cp -pr spec2004-1/logs /tmp/software-info/spec2004-1"
        ssh appserver$i "cd /opt/glassfish/glassfish/domains; cp -pr spec2004-1/autodeploy /tmp/software-info/spec2004-1"
        ssh appserver$i "cd /tmp/software-info/spec2004-1; find ./ -name "*SPECjAppServer_ItemBrowserSes_*" |xargs rm -rf - "
        ssh appserver$i "cd /tmp/software-info/spec2004-1; find ./ -name \"*.dat*\" |xargs rm -rf - "
        ssh appserver$i "cd /tmp/software-info; rm -f  spec2004-1/config/*com_sun_appserv_pid"
        ssh appserver$i "cd /tmp/software-info; rm -f  spec2004-1/config/.*com_sun_appserv_pid"
        ssh appserver$i "cd /tmp/software-info; tar zcf spec2004-1.tgz spec2004-1"
	scp -p appserver$i:/tmp/software-info/spec2004-1.tgz ./
        tar -zxf spec2004-1.tgz
	rm spec2004-1.tgz
	ssh appserver$i "cd /opt/tomcat/; tar zcf /tmp/software-info/tomcat.tgz conf webapps/Emulator.war"
	scp -p appserver$i:/tmp/software-info/tomcat.tgz ./
	tar -zxf tomcat.tgz
        rm tomcat.tgz
	ln -s conf tomcatConf
	echo "Directory contains: /opt/glassfish/domains/spec2004-1, /opt/tomcat/webaps/Emulator.war  and /opt/tomcat/conf" > Readme.txt
        # send request to specemulator
        #curl  --connect-timeout 10 -m 20  http://appserver$i:8080 |grep "Apache Tomcat" > TomcatVersion.out
        ssh appserver$i "/opt/tomcat/bin/version.sh | grep Server" > TomcatVersion.out
        # send request to specdelivery
        #curl  --connect-timeout 10 -m 20 http://appserver$i:8000 |grep "GlassFish"  > GlassFishVersion.out
        ssh appserver$i "/opt/glassfish/bin/asadmin --passwordfile /opt/SPECjAppServer2004/bin/glassfish/passwordfile version" > GlassFishVersion.out

	cd $top/VIRT/tile$i/appserver/VM
	wkldVMcollect appserver $i

####### Collect data on dbserver VMs #######
	cd $top/VIRT/tile$i/dbserver/SOFTW
	ssh dbserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info"
        scp -p dbserver$i:/var/lib/pgsql/9.2/data/postgresql.conf ./
        ssh dbserver$i "psql --version > /tmp/software-info/psql-Version.txt"
        scp -p dbserver$i:/tmp/software-info/psql-Version.txt ./
	ssh dbserver$i "cd /opt/SPECjAppServer2004/; tar zcf /tmp/software-info/postgresql-92.tgz schema/postgresql bin/glassfish"
        scp -p dbserver$i:/tmp/software-info/postgresql-92.tgz ./
	tar -zxf postgresql-92.tgz
        rm postgresql-92.tgz

	cd $top/VIRT/tile$i/dbserver/VM
	wkldVMcollect dbserver $i

####### Collect data on batchserver VMs #######
	cd $top/VIRT/tile$i/batchserver/SOFTW
	ssh batchserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info"
	ssh batchserver$i "cd /tmp/software-info; java -jar /opt/SPECpoll/pollme.jar -v > SPECpollVersion.out"
        scp -p batchserver$i:/tmp/software-info/SPECpollVersion.out ./
	ssh batchserver$i "cd /tmp/software-info; java -version 2> javaVersion.out"
        scp -p batchserver$i:/tmp/software-info/javaVersion.out ./
        mkdir cpu2006; cd cpu2006
	scp -p  batchserver$i:/opt/SPECbatch/cpu2006-virt/virt_sc2013_run.sh ./
	scp -p  batchserver$i:/opt/SPECbatch/cpu2006-virt/config/cpu2006-virt.cfg ./

	cd $top/VIRT/tile$i/batchserver/VM
	wkldVMcollect batchserver $i

####### Collect data on infraserver VMs #######
	cd $top/VIRT/tile$i/infraserver/SOFTW
	ssh infraserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info; cd /tmp/software-info; mkdir etc; cd etc; mkdir httpd"
	#ssh infraserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info; cd /tmp/software-info; mkdir etc; mkdir usr; mkdir usr/local; mkdir usr/local/apache2; mkdir usr/local/apache2/httpd"
	# Collect infraserver web server config files and version
	##ssh infraserver$i "cd /tmp/software-info; cp -p /var/www/fcgi-bin/besim_fcgi.fcgi ./"
	ssh infraserver$i "cd /tmp/software-info; sum /var/www/fcgi-bin/besim_fcgi.fcgi > ./sum.besim_fcgi"
	ssh infraserver$i "cd /tmp/software-info; ldd /var/www/fcgi-bin/besim_fcgi.fcgi > ./ldd.besim_fcgi"
	ssh infraserver$i "cd /tmp/software-info/etc/httpd/; cp -p -r /etc/httpd/conf ./; cp -p -r /etc/httpd/conf.d ./" 
	ssh infraserver$i "cd /tmp/software-info/etc/httpd/; /usr/sbin/httpd -V > httpdVersion.out"
        #ssh infraserver$i "mkdir  /tmp/software-info/etc/init.d; cd  /tmp/software-info/etc/init.d; cp -p /etc/init.d/httpd ./"
        ssh infraserver$i "cd /tmp/software-info; tar -zcf infra.tgz *"
	scp -p infraserver$i:/tmp/software-info/infra.tgz ./
        tar -zxf infra.tgz 
        rm infra.tgz

	cd $top/VIRT/tile$i/infraserver/VM
	wkldVMcollect infraserver $i

####### Collect data on mailserver VMs #######
	cd $top/VIRT/tile$i/mailserver/SOFTW
	ssh mailserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info; cd /tmp/software-info;"
	# Collect mailserver config files and version
	ssh mailserver$i "mkdir  /tmp/software-info/etc; cd /tmp/software-info/etc; cp -p -r /etc/dovecot* ./"
	ssh mailserver$i "cd /tmp/software-info/etc; dovecot --version > dovecotVersion.out; dovecot --build-options >> dovecotVersion.out"
        ssh mailserver$i "mkdir  /tmp/software-info/etc/init.d; cd  /tmp/software-info/etc/init.d; cp -p /etc/init.d/dovecot ./"
        ssh mailserver$i "cd /tmp/software-info; tar -zcf dov.tgz *"
	scp -p mailserver$i:/tmp/software-info/dov.tgz ./
	tar -zxf dov.tgz
	rm dov.tgz

	cd $top/VIRT/tile$i/mailserver/VM
	wkldVMcollect mailserver $i

####### Collect data on webserver VMs #######
	cd $top/VIRT/tile$i/webserver/SOFTW
        ssh webserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info; cd /tmp/software-info; mkdir etc; cd etc; mkdir httpd"
        #ssh webserver$i "rm -rf /tmp/software-info; mkdir /tmp/software-info; cd /tmp/software-info; mkdir etc; mkdir usr; mkdir usr/local; mkdir usr/local/apache2; mkdir usr/local/apache2/httpd"
        # Collect webserver web server config files and version
        ssh webserver$i "cd /tmp/software-info/etc/httpd/; cp -p -r /etc/httpd/conf ./; cp -p -r /etc/httpd/conf.d ./"
        ssh webserver$i "cd /tmp/software-info/etc/httpd; /usr/sbin/httpd -V > httpdVersion.out"
        #ssh webserver$i "mkdir  /tmp/software-info/etc/init.d; cd  /tmp/software-info/etc/init.d; cp -p /etc/init.d/httpd ./"
        ssh webserver$i "grep -i \"^[ ]*DocumentRoot\" /etc/httpd/conf/httpd.conf|tr -d '\"'  |xargs lsattr -R - 2> /tmp/errs |grep support |grep -v dir000 > /tmp/software-info/lsattr.out 2> /tmp/errs"
	# Collect php initialization file and output of php --info
        # which includes details on add-ons (such as APC)
        ssh webserver$i "cd /tmp/software-info/etc; cp -p /etc/php.ini ./"
        ssh webserver$i "cd /tmp/software-info; php --info > phpinfo.out"
	# Collect info on version of Smarty used
	ssh webserver$i "cd /tmp/software-info; cp -p /var/www/html/support/init_vars.php ./"
	# Collect igb driver info (if using passthru)
        ssh webserver$i "cd /tmp/software-info; modinfo igb > modinfo-igb.out"
        ssh webserver$i "cd /tmp/software-info; tar -zcf web.tgz *"
        scp -p webserver$i:/tmp/software-info/web.tgz ./
        tar -zxf web.tgz
        rm web.tgz

	cd $top/VIRT/tile$i/webserver/VM
	wkldVMcollect webserver $i
    done

###############################
cd $top
date > Data-Collection-End.txt
###############################
###set +x
}

#

# 
# wkldVMcollect wlkd tileIndex
#
#  Subroutine collects workload VM specific system data to be save
#  under VIRT
# 
wkldVMcollect () {
wkld=$1
j=$2
	ssh $wkld$j "rm -rf /tmp/wkld-info; mkdir /tmp/wkld-info "
        ssh $wkld$j "cd /tmp/wkld-info; chkconfig --list > chkconfig.txt"
        ssh $wkld$j "cd /tmp/wkld-info; df > df.txt"
        ssh $wkld$j "cd /tmp/wkld-info; ifconfig > ifconfig.txt"
        ssh $wkld$j "cd /tmp/wkld-info; lspci > lspci.txt"
        ssh $wkld$j "cd /tmp/wkld-info; mount > mount.txt"
        ssh $wkld$j "cd /tmp/wkld-info; rpm -q -a > rpmpkgs.txt"
        ssh $wkld$j "cd /tmp/wkld-info; mkdir proc"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/cpuinfo ./"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/devices ./"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/meminfo ./"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/modules ./"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/partitions ./"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/swaps ./"
        ssh $wkld$j "cd /tmp/wkld-info/proc; cp -p /proc/version ./"
        ssh $wkld$j "cd /tmp/wkld-info; mkdir boot; mkdir boot/grub"
        ssh $wkld$j "cd /tmp/wkld-info/boot/grub; cp -p /boot/grub/grub.conf ./"
        ssh $wkld$j "cd /tmp/wkld-info; mkdir var; mkdir var/log"
        ssh $wkld$j "cd /tmp/wkld-info/var/log; cp -p /var/log/dmesg ./"
        ssh $wkld$j "cd /tmp/wkld-info; mkdir etc; mkdir etc/iproute2; mkdir etc/rc.d; mkdir etc/rc.d/init.d; mkdir etc/rc.d/rc3.d; mkdir etc/security"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/bashrc ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/fstab ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/exports ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/hosts ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/inittab ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/nsswitch.conf ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/rc.local ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc; cp -p /etc/sysctl.conf ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc/iproute2; cp -p /etc/iproute2/* ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc/rc.d/init.d; cp -p /etc/rc.d/init.d/* ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc/rc.d/rc3.d; cp -p /etc/rc.d/rc3.d/* ./"
        ssh $wkld$j "cd /tmp/wkld-info/etc/security; cp -p /etc/security/limits.conf ./"
        ssh $wkld$j "cd /tmp/wkld-info; tar cf - *|gzip > /tmp/wkld-info.tgz"
        cd $top/VIRT/tile$i/$wkld/VM
        scp -p $wkld$j:/tmp/wkld-info.tgz  ./
	tar -zxf ./wkld-info.tgz
	rm ./wkld-info.tgz
}

buildDirTree () {
mkdir PHYS
	mkdir PHYS/Clients
for i in `seq 1 $tiles`;
    do
	mkdir PHYS/Clients/$client$i
	mkdir PHYS/Clients/$wclient$i
    done
	mkdir PHYS/SUT
        mkdir PHYS/Clients/VMdata

mkdir VIRT
for i in `seq 1 $tiles`;
    do
	mkdir VIRT/tile$i
	mkdir VIRT/tile$i/appserver
	mkdir VIRT/tile$i/appserver/SOFTW
	mkdir VIRT/tile$i/appserver/VM
	mkdir VIRT/tile$i/dbserver
	mkdir VIRT/tile$i/dbserver/SOFTW
	mkdir VIRT/tile$i/dbserver/VM
	mkdir VIRT/tile$i/batchserver
	mkdir VIRT/tile$i/batchserver/SOFTW
	mkdir VIRT/tile$i/batchserver/VM
	mkdir VIRT/tile$i/infraserver
	mkdir VIRT/tile$i/infraserver/SOFTW
	mkdir VIRT/tile$i/infraserver/VM
	mkdir VIRT/tile$i/mailserver
	mkdir VIRT/tile$i/mailserver/SOFTW
	mkdir VIRT/tile$i/mailserver/VM
	mkdir VIRT/tile$i/webserver
	mkdir VIRT/tile$i/webserver/SOFTW
	mkdir VIRT/tile$i/webserver/VM
    done
}

#########################
#  Invoke Main Routine  #
#########################

main "$@"

