#!/bin/sh 
#
#  Copyright  2006-2011 VMware, Inc. All rights reserved.
#
#
#   This file is part of the VMmark Harness.
#
#    The VMmark Harness is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License, Version 2.0,
#    as published by the Free Software Foundation.
#
#    The VMmark Harness is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with the VMmark Harness; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
##############################################################################
#
#       Collects various configuration and log files for benchmark disclosure 
#       with VMware vSphere. On ESX 5.0, this script prepares output from the 
#		VMware vSphere support script vm-support for benchmark submission. On 
#		ESX 4.1, the script copies and edits the vm-support script, removes 
#		unneeded files, and creates a more manageable tgz file for benchmark 
#		submission.
#
#
#	FOR BOTH ESXi 4.1 and 5.0: Follow this step before running the reporting script 
#	(may require a reboot).
#
#	    Point the scratch location to a real disk to avoid inadvertent out of disk 
#	    space errors. Click on the server then Configuration tab > Software > Advanced
#	    Settings. Click on ScratchConfig. Make sure ScratchConfig.ConfiguredScratchLocation 
#	    points to a writeable directory on the VMFS partition (/vmfs/volumes/...). 
#	    Requires a reboot to take effect.
#
#	FOR ESXi 4.1 ONLY:
#
#	Log into the vSphere client.
#
#	    Adjust memory allocations to vmvisor and shell processes: Click on 
#	    the server then Configuration tab > System Resource Allocation > Advanced.
#
#		For vmvisor: Scroll through the hierarchy to host > vim > vmvisor. 
#           Click Edit Settings, and under Memory Resources increase Limit by 512 MB.
#
#		For shell: Scroll through the hierarchy to host > vim > vmvisor > shell. 
#           Click Edit Settings, and under Memory Resources increase Limit by 512 MB.
#
#
##############################################################################
#

date
# Version 1.3 - 08102011 - Updated for ESXi 5.0
#
# Define variables

#HOSTNAME=$(hostname -s 2>/dev/null)
HOSTNAME=dl380p-gen8
DATE=$(date +"%Y%m%d-%H%M")
SUBMITDIR=$HOSTNAME-$DATE
SUBMITFILE=$HOSTNAME-$DATE.tgz
REPORTDIR=/vmfs/volumes/SSD-Store1/reporter

# Determine whether installation is ESXi or ESX
COS=$(if [ $(uname) = "Linux" ]; then echo 1; else echo 0; fi)
# Determine whether installation is 4.x or earlier
VERSION=$(if [ "$(vmware -v | grep 'ESXi* [1-4]\.')" ]; then echo 4; else echo 5; fi)
#
#Choose LUN for reporting directory that has enough disk space for the reporter file.
# 
if [ "$COS" = 1 ]; then
   LUNS=$(vdf | grep /vmfs/volumes/ | awk '{print $3}' | sed '/^$/d')
else
   LUNS=$(df -k | awk '{print $4 $6 $7}' | sed '1d')
fi
#for i in $LUNS; do
#   STR=$(echo $i) 
#   KBFREE=$(echo ${STR%%\/*})
#   if [ $KBFREE -gt 8388608 ] ; then
#   # Search for large enough available kb value, then find its matching lun. Check no spaces exist in lun name.
#      if [ "$COS" = 1 ]; then
#         LUN=$(vdf | grep "$KBFREE" | tail -1 | awk '{print $5}' | sed 's/\/vmfs\/volumes\///')
#	  else
#         LUN=$(df -k | grep "$KBFREE" | tail -1 | awk '{print $6}' | sed 's/\/vmfs\/volumes\///')
#	  fi
#      if [ "$(ls /vmfs/volumes | grep "$LUN" | grep -v " ")" != "" -a "$LUN" != "" ]
#      then
#		 cd /vmfs/volumes/$LUN
#		 # Determine whether the LUN is writeable by testing file creation (twice)
#		 TRIES=0
#		 while [ "$TRIES" -le 1 ] ; do
#		    touch testfile 2>/dev/null
#		    if [ -e testfile ] ; then
#			   rm testfile 2>/dev/null
#	           break
#	        else
#			   TRIES=$((TRIES+1))
#			fi
#		 done 
#		 cd - >/dev/null
#   	     if [ "$TRIES" -le 1 ] ; then
#			REPORTDIR=/vmfs/volumes/$LUN/reporter
#	        break
#	     fi
#      fi
#   fi
#done
WORKDIR=$REPORTDIR/$HOSTNAME
mkdir -pm 755 $WORKDIR

echo 
echo Configuration Gathering Script for VMware vSphere
echo
echo Running configuration-gathering script. This may take several minutes

if [ "$VERSION" = 4 ]; then
   cd /tmp

   # Edit standard vm-support script to get only what we need (don't create 
   #    tar, don't get old logs)
   if [ "$COS" = "1" ]; then
      cp /usr/bin/vm-support $WORKDIR/vm-support-orig
   else
      cp /sbin/vm-support $WORKDIR/vm-support-orig
   fi	
   sed -e '
      s/messages\*/messages/g
      s/vmkernel\*/vmkernel/g
      s/rpmpkgs\*/rpmpkgs/g
      s/secure\*/secure/g
      s/cron\*/cron/g
      s/vmkiscsid\*/vmkiscsid/g
      s/vmksummary\*/vmkernel/g
      s/vmkwarning\*/vmkwarning/g
      s/vmware-core\*/vmware-core/g
      s/zdump\*/zdump/g
      s/core\*/core/g
      s/\/vmware\/"/\/vmware\/\*.log\"/g
      s/\*.log/vmware.log/g
      /createTar()/a\
      return
      /^t$/a\
   ' $WORKDIR/vm-support-orig > $WORKDIR/int-vm-support 2>/dev/null

   grep "grep -v" $WORKDIR/int-vm-support | grep do > /tmp/procline
   if [ -s /tmp/procline ]; then
      sed -e '
         s/-type f 2\>.*/ \> \/dev\/null\)\; do/g
		 ' $WORKDIR/int-vm-support > $WORKDIR/my-vm-support 2>/dev/null
   else 	
      sed -e '
         s/-type f 2\>.*/ \> \/dev\/null/g
      ' $WORKDIR/int-vm-support > $WORKDIR/my-vm-support 2>/dev/null
   fi
   chmod 755 $WORKDIR/my-vm-support
   rm -f $WORKDIR/int-vm-support $WORKDIR/vm-support-orig 2>/dev/null

   # Run my-vm-support with switches: -n = don't get cores, 
   #   -q = quiet mode, -w = set output dir
   if [ "$COS" = "1" ]; then
      $WORKDIR/my-vm-support -nqmfw $WORKDIR 2>/dev/null
   else
      $WORKDIR/my-vm-support -nmqw $WORKDIR 2>/dev/null
   fi
fi

if [ "$VERSION" = 5 ] ; then
#   OUTPUTSTR=$(vm-support -w $WORKDIR |tail -1)
   OUTPUTSTR=$(vm-support -a Benchmark:SPECvirt -w $WORKDIR |tail -1)
   # Extract vm-support filename from vm-support output string
   VMSUPPORTFILE=$(echo ${OUTPUTSTR#T*$HOSTNAME\/} | sed 's/.$//')
   VMSUPPORTDIR=$(echo ${VMSUPPORTFILE%\.tgz})
   echo VMSupportFile is $VMSUPPORTFILE and VMSupportDir is $VMSUPPORTDIR
   cd $WORKDIR
   mkdir commands etc
   mkdir etc/vmware
   
# commented out for test
#   tar -xvzf $VMSUPPORTFILE >/dev/null
#   rm $VMSUPPORTFILE
#   cd $VMSUPPORTDIR
# end of commented test

#   ./reconstruct.sh
#   rm -rf vmfs/volumes/*/*/vmware-*.log
   mkdir -pm 755 tmp
fi

echo 
echo Configuration-gathering script finished. Beginning post-processing
echo
echo 'You can ignore any "Skipping invalid VM" errors'
echo

if [ "$VERSION" = 4 ] ; then
   VMSUPPORTDIR=$(ls  $WORKDIR | grep vm-support-)
   cd $WORKDIR/$VMSUPPORTDIR

   # Get /proc/vmware and /var/log/vmware directories
   mkdir -pm 755 proc/vmware var/log/vmware tmp 2>/dev/null
   find /proc -maxdepth 1 -type f | xargs tar -cf - --exclude=1* --exclude=2* --exclude=3* --exclude=4* \
   --exclude=5* --exclude=6* --exclude=7* --exclude=8* --exclude=9* /proc/* | (cd $WORKDIR/$VMSUPPORTDIR ; tar -xf - )
   cp -prL /var/log/vmware/*.log var/log/vmware 2>/dev/null
fi
#
# Getting list of all running VM guests
#
VMID=$(vim-cmd vmsvc/getallvms | awk '{print $1}' | grep -vE '(Vmid)') 2>/dev/null           
echo Powered on VMs are > tmp/all-powered-on-VMs.txt
for i in $VMID; do
   STATE=$(vim-cmd vmsvc/power.getstate $i | tail -1 | awk '{print $2}') 2>/dev/null           
      if [ $STATE == on ]                                                           
      then    
	     VMNAME=$(vim-cmd vmsvc/get.summary $i | grep name | awk '{print $3}' | sed 's/\"\|,//g') 2>/dev/null	
         echo $VMNAME >> tmp/all-powered-on-VMs.txt
      else
         VMPATH=$(vim-cmd vmsvc/getallvms | grep $i | awk '{print $4}')
		 VMDIR=$(echo ${VMPATH%%\/*})
		 rm -rf $WORKDIR/$VMSUPPORTDIR/vmfs/volumes/*/$VMDIR
      fi
done  
if [ "$VMNAME" = "" ]
then
		echo No VMs are powered on. >> tmp/all-powered-on-VMs.txt 2>/dev/null	
fi
#
# Get vsicache hwinfo if ESXi
#
if [ "$COS" = "0" ]; then
	vmkvsitools hwinfo -i > tmp/vsicache-hwinfo.txt 2>/dev/null
fi

cp /etc/vmware/esx.conf etc/vmware

#
# Manually gather files for ESX 5
#
if [ "$VERSION" = 5 ] ; then
   mv tmp/* commands
   rmdir tmp   
   esxcli software vib list > commands/esxcli_software_vib_list.txt 2>/dev/null
   vsish -e get /system/version > commands/vsish_system_version.txt 2>/dev/null
   vsish -e get /config/SvMotion/intOpts/SvMotionAvgDisksPerVM > commands/vsish_SvMotionAvgDisksPerVM.txt 2>/dev/null
   vsish -e get /sched/numaStats/numaNodes/0 > commands/vsish_NumaNode0.txt 2>/dev/null
   vsish -e get /config/Power/strOpts/CpuPolicy > commands/vsish_Power_CpuPolicy.txt 2>/dev/null
   vsish -e get /net/pNics/vmnic0/properties > commands/vsish_pNic0.txt 2>/dev/null
   vsish -e get /config/Migrate/intOpts/MigrateCpuSharesHighPriority > commands/vsish_MigrateCpuShares.txt 2>/dev/null
# newly added
   cp /etc/vmware/esx.conf etc/vmware
   esxcli software vib list > commands/esxcli_software_vib_list.txt 2>/dev/null
   vsish -e get /config/SvMotion/intOpts/SvMotionAvgDisksPerVM > commands/vsish_SvMotionAvgDisksPerVM.txt 2>/dev/null  
# end of new add

fi

echo Post-processing finished. Starting clean up

if [ "$VERSION" = 4 ] ; then
   mv vmfs/volumes/*/reporter/$HOSTNAME*/* tmp 2>/dev/null
   rm -rf etc/pam.d etc/sysconfig/network-scripts 2>/dev/null
   rm -rf var/log/cron.* var/log/messages.* var/log/vmk*.* var/log/rpm*.* var/log/secure*.* var/log/cron.* var/log/messages.* var/log/vmk*.* var/log/rpm*.* var/log/secure*.* var/log/vmware/*.log.* 2>/dev/null
   rm -rf proc/sys/net proc/vmware/vm 2>/dev/null
   rm -rf tmp/vmware-vimdump*.txt tmp/esxcfg-info-xml* 2>/dev/null
   rm -rf usr/lib/vmware/licenses 2>/dev/null
   rm -rf vmware/hostd-*.log* 2>/dev/null
   rm -rf vmfs/volumes/*/*/vmware-*.log  2>/dev/null
   rm -rf $WORKDIR/vmkiscs* $WORKDIR/my-vm-support 2>/dev/null
   rm -rf /tmp/procline
fi

cd $WORKDIR

# debug break
#echo "Workdir=$WORKDIR"
#echo "VMSupportdir=$VMSUPPORTDIR"
#echo "Supportdir=$SUPPORTDIR"
#echo "Submitdir=$SUBMITDIR"
#pwd

#exit
#end of break

#temporary commented out
#mv $VMSUPPORTDIR $SUBMITDIR

#rm -rf $SUBMITDIR/commands/*traverse*[0-9]
#rm -rf $SUBMITDIR/var/run/log/*[0-9]gz
#rm -rf $SUBMITDIR/usr/lib/vmware/licenses
#end of temporary comment

echo creating TGZ $REPORTDIR/$SUBMITFILE

mv $WORKDIR/$VMSUPPORTFILE $REPORTDIR/$VMSUPPORTFILE
tar -czf $REPORTDIR/$SUBMITFILE . 2>/dev/null
#rm -rf $WORKDIR 2>/dev/null; rm -rf $WORKDIR 2>/dev/null
#
# Publish tgz path for calling scripts
#
printf "$REPORTDIR/$VMSUPPORTFILE\n" >> /tmp/ResultsPath.txt 2>/dev/null
printf "$REPORTDIR/${SUBMITFILE}\n" >> /tmp/ResultsPath.txt 2>/dev/null

#echo $REPORTDIR/$SUBMITFILE > /tmp/tgzpath 2>/dev/null
echo
echo Cleanup finished. 
echo
echo Include $REPORTDIR/$SUBMITFILE as part of your benchmark submission.
echo
echo Done!
echo
date
