#!/bin/bash
# script assumes you are in the Virtual_Configuration subdir

. /root/specvirt_vars.sh

num_tiles=$1
sut=${prefix}${host}
cp_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps proc/mounts proc/version proc/mounts proc/cmdline'
tar_files='boot/grub/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/sysctl.conf etc/security/limits* etc/modprobe* etc/rc.d/rc3.d/ etc/rc.d/rc.local etc/rc.d/init.d/ var/log/dmesg root/reconfigure_network.sh'

cp -rp /root/sc2013_pub/Collection_scripts .
mkdir -p guest-xml-config
pushd guest-xml-config >/dev/null
    for tile in `seq 1 $num_tiles`; do
        zpt=`printf "%02d" $tile`
        for vmtype in web app db batch infra mail; do
            if [ "$vmtype" = "db" ]; then
                rest=$[$tile%4]
                if [ "$rest" != 1 ]; then
                    continue
                fi
            fi       
            scp ${sut}:/autobench/logs/specvirt*/config/libvirt.guest.before.001/*${vmtype}t${zpt}.xml .
	done
    done
popd >/dev/null

for tile in `seq 1 $num_tiles`; do
    zpt=`printf "%02d" $tile`
    mkdir -p tile$tile
    pushd tile$tile >/dev/null
    for vmtype in web app db batch infra mail; do
        if [ "$vmtype" = "db" ]; then
            rest=$[$tile%4]
            if [ "$rest" != 1 ]; then
                continue
            fi
        fi           
        dir="${vmtype}server"
        mkdir -p $dir
        pushd $dir >/dev/null
        mkdir -p VM_configuration
        pushd VM_configuration
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} "cd /; tar chf - $tar_files" | tar xf -
        mkdir -p ./proc
        for file in $cp_files; do
            ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} cat /$file >./$file
        done
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} ifconfig -a >ifconfig.txt
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} chkconfig --list >chkconfig.txt
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} mount -l >mount.txt
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} df >df.txt
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} lspci >lspci.txt
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} rpm -qa >rpmpkgs.txt
        ssh -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt} tuned-adm active  >tuned-adm.txt 
        popd >/dev/null # VM_configuration
    
        mkdir -p Software_Configuration
        pushd Software_Configuration >/dev/null
        case $vmtype in
	    "web")
	    mkdir -p httpd
	    scp -r -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/httpd/conf ./httpd/
	    scp -r -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/httpd/conf.d ./httpd/
	    mkdir -p php
	    scp -r -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/php.ini ./php/
	    scp -r -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/php.d ./php/
	    ;;
	    "app")
	    for i in 01 02; do
	        mkdir -p AppSrv$i
	        # scp -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/opt/IBM/WebSphere/AppServer/profiles/AppSrv$i/config/cells/appNode${i}Cell/nodes/appNode$i/servers/server1/server.xml ./AppSrv$i/server.xml
	          scp -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/opt/IBM/WebSphere/AppServer/profiles/AppSrv${i}/config/cells/appNode${i}Cell/nodes/appNode${i}/servers/server1/server.xml ./AppSrv$i/server.xml
	    done
	    ;;
	    "db")
	    scp -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/home/db2inst1/sqllib/db2nodes.cfg .
	    scp -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/home/db2inst1/sqllib/profile.env .
	    ;;
	    "infra")
	    scp -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/exports exports
	    mkdir -p httpd
	    scp -r -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/httpd/conf ./httpd/
	    scp -r -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/etc/httpd/conf.d ./httpd/
	    ;;
	    "mail")
	    scp -o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no ${prefix}${vmtype}t${zpt}:/autobench/sources/SPECvirt_sc2013-v1.000GA/SPECimap/dovecot/dist/etc/dovecot/dovecot.conf .
	    ;;
        esac
        popd >/dev/null  # Software_Configuration
        popd >/dev/null  # $dir
    done
    popd >/dev/null
done
