#! /bin/bash
prefix=vn-
client_vm_topology="vn-ct06:vn-vct01,vn-vct05,vn-vct09,vn-vct13,vn-vct17,vn-vct21::vn-ct07:vn-vct02,vn-vct06,vn-vct10,vn-vct14,vn-vct18,vn-vct22::vn-ct08:vn-vct03,vn-vct07,vn-vct11,vn-vct15,vn-vct19,vn-vct23::vn-ct09:vn-vct04,vn-vct08,vn-vct12,vn-vct16,vn-vct20::vn-master:"
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering client data..."
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*'

for phys_client_and_vms in ${client_vm_topology//::/ }; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    mkdir -p $phys_client
    pushd $phys_client >/dev/null
    ssh $SSH_OPTIONS $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cat_files; do
        ssh $SSH_OPTIONS $phys_client "cat /$file" >$file
    done
    ssh $SSH_OPTIONS $phys_client ifconfig -a >ifconfig.txt
    ssh $SSH_OPTIONS $phys_client brctl show >brctl-show.txt
    ssh $SSH_OPTIONS $phys_client chkconfig --list >chkconfig.txt
    ssh $SSH_OPTIONS $phys_client mount -l >mount.txt
    ssh $SSH_OPTIONS $phys_client df >df.txt
    ssh $SSH_OPTIONS $phys_client lspci >lspci.txt
    ssh $SSH_OPTIONS $phys_client rpm -qa >rpmpkgs.txt
    ssh $SSH_OPTIONS $phys_client vgdisplay >vgdisplay.txt
    ssh $SSH_OPTIONS $phys_client lvdisplay >lvdisplay.txt
    ssh $SSH_OPTIONS $phys_client "ps aux | grep qemu-kvm | grep -v grep" >running-vms.txt
    ssh $SSH_OPTIONS $phys_client "virsh list" >virsh-list.txt
    vm_clients=`echo $phys_client_and_vms | sed -e s/"^${phys_client}:"//`
    for vm_client in ${vm_clients//,/ }; do
        echo "  vm_client is $vm_client"
        zpt=`echo $vm_client | sed -e 's/.*t\([0-9]\+\)$/\1/'`
        mkdir -p tile${zpt}
        pushd tile${zpt} >/dev/null
        ssh $SSH_OPTIONS $vm_client "cd /; tar chf - $tar_files" | tar xf -
        mkdir proc
        for file in $cat_files; do
            ssh $SSH_OPTIONS $vm_client cat /$file >$file
        done
        ssh $SSH_OPTIONS $vm_client ifconfig -a >ifconfig.txt
        ssh $SSH_OPTIONS $vm_client chkconfig --list >chkconfig.txt
        ssh $SSH_OPTIONS $vm_client mount -l >mount.txt
        ssh $SSH_OPTIONS $vm_client df >df.txt
        ssh $SSH_OPTIONS $vm_client lspci >lspci.txt
        ssh $SSH_OPTIONS $vm_client rpm -qa >rpmpkgs.txt
        mkdir config
        ssh $SSH_OPTIONS $vm_client '. /etc/autobench_instances; cd $MASTER_AUTODIR/sources/SPECvirt_sc2013/SPECjAppServer2004-prime; tar chf - config/*.properties' | tar xf -
        popd >/dev/null
    done
    popd >/dev/null
done
