#! /bin/bash
num_tiles=22
sut=vn-host
prefix=vn-
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering VM data..."
if [ -e ~/README-VM-notes.txt ]; then
    cp -p ~/README-VM-notes.txt .
fi
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps proc/mounts proc/version proc/cmdline'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/sysctl.conf etc/security/limits* etc/modprobe* etc/rc.d/rc3.d/ etc/rc.d/rc.local etc/rc.d/init.d/ var/log/dmesg'
mkdir -p guest-xml-config
pushd guest-xml-config >/dev/null
    for tile in `seq 1 $num_tiles`; do
        zpt=`printf "%02d" $tile`
        for vmtype in web app db batch infra mail; do
            if [ "$vmtype" = "db" ]; then
                rest=$[$tile%4]
                if [ "$rest" != 1 ]; then
                    continue
                fi
            fi
            scp ${sut}:/autobench/logs/specvirt*/config/libvirt.guest.before.001/*${vmtype}t${zpt}.xml .
        done
    done
popd >/dev/null

for tile in `seq 1 $num_tiles`; do
    zpt=`printf "%02d" $tile`
    mkdir -p tile$tile
    pushd tile$tile >/dev/null
    for vmtype in web app db batch infra mail; do
        if [ "$vmtype" = "db" ]; then
            if [ "$(($tile%4))" != 1 ]; then
                continue
            fi
        fi
        dir="${vmtype}server"
        mkdir -p $dir/VM_configuration
        pushd $dir/VM_configuration >/dev/null
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} "cd /; tar chf - $tar_files" | tar xf -
        mkdir -p proc
        for file in $cat_files; do
            ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} "cat /$file" >$file
        done
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} ifconfig -a >ifconfig.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} chkconfig --list >chkconfig.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} mount -l >mount.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} df >df.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} lspci >lspci.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} rpm -qa >rpmpkgs.txt
        ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} tuned-adm active >tuned-adm.txt
        popd >/dev/null

        mkdir -p $dir/Software_Configuration
        pushd $dir/Software_Configuration >/dev/null
        case $vmtype in
            "web")
                mkdir -p httpd
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/httpd/conf httpd/
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/httpd/conf.d httpd/
                mkdir -p php
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/php.ini php/
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/php.d php/
            ;;
            "app")
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} '. /etc/autobench_instances; cd $MASTER_AUTODIR/sources/SPECvirt_sc2013/SPECjAppServer2004/; tar chf - WebSphere_setup/*.jacl' | tar xf -
                ear_files=$(ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} 'find /opt/IBM/WebSphere/AppServer/profiles -type f -name \*.ear')
                for ear in $ear_files; do
                    scp -p ${prefix}${vmtype}t${zpt}:$ear WebSphere_setup/
                done
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} '. /etc/autobench_instances; . $MASTER_AUTODIR/var/logdir; cd $LOGDIR/benchmark/; tar chf - WebSphere-config' | tar xf -
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} '. /etc/autobench_instances; . $MASTER_AUTODIR/var/logdir; cd $LOGDIR/benchmark/; tar chf - WebSphere-logs' | tar xf -
                mkdir AppSrv01
                scp -p ${prefix}${vmtype}t${zpt}:/opt/IBM/WebSphere/AppServer/profiles/AppSrv01/config/cells/*/nodes/*/servers/*/server.xml AppSrv01/
                mkdir AppSrv02
                scp -p ${prefix}${vmtype}t${zpt}:/opt/IBM/WebSphere/AppServer/profiles/AppSrv02/config/cells/*/nodes/*/servers/*/server.xml AppSrv02/
            ;;
            "db")
                scp $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/home/db2inst1/sqllib/db2nodes.cfg .
                scp $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/home/db2inst1/sqllib/profile.env .
                ssh $SSH_OPTIONS ${prefix}${vmtype}t${zpt} '. /etc/autobench_instances; . $MASTER_AUTOBENCH/var/logdir; cd $LOGDIR/benchmark; tar chf - *.cfg' | tar xf -
                mkdir -p schema
                scp -p $SSH_OPTIONS /autobench/sources/SPECvirt_sc2013/SPECjAppServer2004/schema/db2/* schema/
            ;;
            "infra")
                scp $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/exports exports
                mkdir -p httpd
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/httpd/conf httpd/
                scp -pr $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/etc/httpd/conf.d httpd/
            ;;
            "mail")
                scp $SSH_OPTIONS ${prefix}${vmtype}t${zpt}:/autobench/sources/SPECvirt_sc2013-v1.000GA/SPECimap/dovecot/dist/etc/dovecot/dovecot.conf .
            ;;
        esac
        popd >/dev/null
    done
    popd >/dev/null
done
