#!/bin/bash

#cd /root
rm -rf data_collection
mkdir -p data_collection

#client configure
fn_getClientInfo()
{
    for i in 153 188
    do
        clientphydir=data_collection/Physical_Configuration/Client_phy$i/Physical_Configuration	
        mkdir -p $clientphydir/boot/grub/
        scp 192.1.1.$i:/boot/grub/menu.lst $clientphydir/boot/grub/
        mkdir -p  $clientphydir/etc
        scp 192.1.1.$i:/etc/sysctl.conf $clientphydir/etc
        scp 192.1.1.$i:/etc/HOSTNAME $clientphydir/etc
        mkdir -p  $clientphydir/etc/sysconfig/network
        scp 192.1.1.$i:/etc/sysconfig/network/ifcfg* $clientphydir/etc/sysconfig/network
        mkdir -p  $clientphydir/etc/init.d/
        scp -r 192.1.1.$i:/etc/init.d/* $clientphydir/etc/init.d
        scp 192.1.1.$i:/etc/bash.bashrc $clientphydir/etc
        scp 192.1.1.$i:/etc/profile $clientphydir/etc
        mkdir -p  $clientphydir/proc
        ssh 192.1.1.$i "cat /proc/cpuinfo" > $clientphydir/proc/cpuinfo
        ssh 192.1.1.$i "cat /proc/devices" > $clientphydir/proc/devices
        ssh 192.1.1.$i "cat /proc/meminfo" > $clientphydir/proc/meminfo
        ssh 192.1.1.$i "cat /proc/modules" > $clientphydir/proc/modules
        ssh 192.1.1.$i "cat /proc/partitions" > $clientphydir/proc/partitions
        ssh 192.1.1.$i "cat /proc/swaps" > $clientphydir/proc/swaps
        mkdir -p  $clientphydir/var/log
        ssh 192.1.1.$i "dmesg" >  $clientphydir/var/log/dmesg.txt
        ssh 192.1.1.$i "brctl show" > $clientphydir/brctl-show.txt
        ssh 192.1.1.$i "chkconfig" > $clientphydir/chkconfig.txt
        ssh 192.1.1.$i "df" > $clientphydir/df.txt
        ssh 192.1.1.$i "ifconfig" > $clientphydir/ifconfig.txt
        ssh 192.1.1.$i "lspci" > $clientphydir/lspci.txt
        ssh 192.1.1.$i "lvdisplay" > $clientphydir/lvdisplay.txt
        ssh 192.1.1.$i "mount" > $clientphydir/mount.txt
        ssh 192.1.1.$i "rpm -qa" > $clientphydir/rpmpkgs.txt
        ssh 192.1.1.$i "vgdisplay" > $clientphydir/vgdisplay.txt
    done    
    
    clientvmdir=data_collection/Physical_Configuration/Client_phy$i/VM_configuration
    vmnum=1
    vmend=$1
    for((j=$vmnum;j<=$vmend;j++))
    do
        mkdir -p $clientvmdir/client$j/boot/grub/
        scp 192.1.$j.7:/boot/grub/grub.conf $clientvmdir/client$j/boot/grub/
        mkdir -p  $clientvmdir/client$j/etc/iproute2
        mkdir -p  $clientvmdir/client$j/etc/rc.d/init.d
        mkdir -p  $clientvmdir/client$j/etc/rc.d/rc3.d
        scp 192.1.$j.7:/etc/iproute2/* $clientvmdir/client$j/etc/iproute2/
        scp -r 192.1.$j.7:/etc/rc.d/init.d/* $clientvmdir/client$j/etc/rc.d/init.d
        scp 192.1.$j.7:/etc/rc.d/rc3.d/* $clientvmdir/client$j/etc/rc.d/rc3.d
        scp 192.1.$j.7:/etc/fstab $clientvmdir/client$j/etc
        scp 192.1.$j.7:/etc/hosts $clientvmdir/client$j/etc
        scp 192.1.$j.7:/etc/inittab $clientvmdir/client$j/etc
        scp 192.1.$j.7:/etc/nsswitch.conf $clientvmdir/client$j/etc
        scp 192.1.$j.7:/etc/sysctl.conf $clientvmdir/client$j/etc
        scp 192.1.$j.7:/etc/rc.local $clientvmdir/client$j/etc
        scp 192.1.$j.7:/etc/bashrc $clientvmdir/client$j/etc
        mkdir -p  $clientvmdir/client$j/etc/sysconfig/network-scripts/
        scp 192.1.$j.7:/etc/sysconfig/network-scripts/ifcfg* $clientvmdir/client$j/etc/sysconfig/network-scripts/
        scp 192.1.$j.7:/etc/sysconfig/network $clientvmdir/client$j/etc/sysconfig
        mkdir -p  $clientvmdir/client$j/proc
        ssh 192.1.$j.7 "cat /proc/cmdline" > $clientvmdir/client$j/proc/cmdline
        ssh 192.1.$j.7 "cat /proc/cpuinfo" > $clientvmdir/client$j/proc/cpuinfo
        ssh 192.1.$j.7 "cat /proc/devices" > $clientvmdir/client$j/proc/devices
        ssh 192.1.$j.7 "cat /proc/meminfo" > $clientvmdir/client$j/proc/meminfo
        ssh 192.1.$j.7 "cat /proc/modules" > $clientvmdir/client$j/proc/modules
        ssh 192.1.$j.7 "cat /proc/mounts" > $clientvmdir/client$j/proc/mounts 
        ssh 192.1.$j.7 "cat /proc/partitions" > $clientvmdir/client$j/proc/partitions
        ssh 192.1.$j.7 "cat /proc/swaps" > $clientvmdir/client$j/proc/swaps
        ssh 192.1.$j.7 "cat /proc/version" > $clientvmdir/client$j/proc/version
        mkdir -p  $clientvmdir/client$j/var/log
        ssh 192.1.$j.7 "dmesg" > $clientvmdir/client$j/var/log/dmesg.txt
        ssh 192.1.$j.7 "chkconfig" > $clientvmdir/client$j/chkconfig.txt
        ssh 192.1.$j.7 "df" > $clientvmdir/client$j/df.txt
        ssh 192.1.$j.7 "ifconfig" > $clientvmdir/client$j/ifconfig.txt
        ssh 192.1.$j.7 "lspci" > $clientvmdir/client$j/lspci.txt
        ssh 192.1.$j.7 "mount" > $clientvmdir/client$j/mount.txt
        ssh 192.1.$j.7 "rpm -qa" > $clientvmdir/client$j/rpmpkgs.txt
    done

fn_getSUTInfo()
{
    SUTphydir=data_collection/Physical_Configuration/System_Under_Test
    mkdir -p $SUTphydir/createvm
#    cp /mnt/207bak/xml/vhost_7tile_xml/xml/1-define.sh $SUTphydir/createvm/
#    cp /mnt/207bak/xml/vhost_7tile_xml/xml/2-start.sh $SUTphydir/createvm/
    cp /mnt/5885_23tile_xml/vhost_xml/1-define.sh $SUTphydir/createvm/
    cp /mnt/5885_23tile_xml/vhost_xml/2-start.sh $SUTphydir/createvm/
    mkdir -p $SUTphydir/vmconfig
    for((l=1;l<=$1;l++))
    do
        mkdir -p $SUTphydir/vmconfig/tile$l
        cp -r /mnt/5885_23tile_xml/vhost_xml/tile$l/* $SUTphydir/vmconfig/tile$l/
    done
    mkdir -p $SUTphydir/boot/grub/
    cp /boot/grub/menu.lst $SUTphydir/boot/grub/
    mkdir -p  $SUTphydir/etc
    cp /etc/sysctl.conf $SUTphydir/etc
    cp /etc/HOSTNAME $SUTphydir/etc
    mkdir -p  $SUTphydir/etc/sysconfig/network
    cp /etc/sysconfig/network/ifcfg* $SUTphydir/etc/sysconfig/network
    mkdir -p  $SUTphydir/etc/init.d/
    cp -r /etc/init.d/* $SUTphydir/etc/init.d
    cp /etc/bash.bashrc $SUTphydir/etc
    cp /etc/profile $SUTphydir/etc
    du -a /etc | awk '{print $2}' > $SUTphydir/etc/directorytree
    mkdir -p  $SUTphydir/proc
    cat /proc/cpuinfo > $SUTphydir/proc/cpuinfo
    cat /proc/devices > $SUTphydir/proc/devices
    cat /proc/meminfo > $SUTphydir/proc/meminfo
    cat /proc/modules > $SUTphydir/proc/modules
    cat /proc/partitions > $SUTphydir/proc/partitions
    cat /proc/swaps  > $SUTphydir/proc/swaps
    mkdir -p  $SUTphydir/var/log
    dmesg > $SUTphydir/var/log/dmesg.txt
    brctl show > $SUTphydir/brctl-show.txt
    chkconfig > $SUTphydir/chkconfig.txt
    df > $SUTphydir/df.txt
    ifconfig > $SUTphydir/ifconfig.txt
    lspci > $SUTphydir/lspci.txt
    lvdisplay > $SUTphydir/lvdisplay.txt
    mount > $SUTphydir/mount.txt
    rpm -qa > $SUTphydir/rpmpkgs.txt
    vgdisplay > $SUTphydir/vgdisplay.txt
    virsh list --all > $SUTphydir/virsh-list.txt
    ps -ef | grep qemu-kvm > $SUTphydir/running-vms.txt
    scp 192.1.1.7:/opt/SPECvirt/3-setMTU.sh $SUTphydir/setMTU.sh
    cp /mnt/207bak/0-sh/1-kaijiqidong-client2/2-reload-ixgbe.sh $SUTphydir/reload-ixgbe.sh
    mkdir -p $SUTphydir/kernel_para
    cat /proc/sys/kernel/sched_latency_ns > $SUTphydir/kernel_para/sched_latency_ns
    cat /proc/sys/kernel/sched_min_granularity_ns > $SUTphydir/kernel_para/sched_min_granularity_ns
    cat /proc/sys/kernel/sched_wakeup_granularity_ns > $SUTphydir/kernel_para/sched_wakeup_granularity_ns
    cp /mnt/0-sh/3-tiaoyou/setcfs.sh $SUTphydir/kernel_para/
}
#SUT VM configure
fn_getSUTVMInfo()
{
    for((i=1;i<=$1;i++))
    do
        appsoftdir=data_collection/Virtual_Configuration/tile$i/appserver/Software_Configuration
        mkdir -p $appsoftdir
        scp 192.1.$i.4:/opt/SUNWjAppServer2004/appservers/tomcat/conf/server.xml $appsoftdir
        scp 192.1.$i.4:/opt/glassfish/glassfish/domains/spec2004-1/config/domain.xml $appsoftdir
	scp 192.1.$i.4:/opt/glassfish/glassfish/domains/spec2004-1/logs/* $appsoftdir
        
        batchsoftdir=data_collection/Virtual_Configuration/tile$i/batchserver/Software_Configuration
        mkdir -p $batchsoftdir
        
        infrasoftdir=data_collection/Virtual_Configuration/tile$i/infraserver/Software_Configuration
        mkdir -p $infrasoftdir
        scp 192.1.$i.1:/etc/exports $infrasoftdir
        scp 192.1.$i.1:/etc/httpd/conf/httpd.conf $infrasoftdir
        
        mailsoftdir=data_collection/Virtual_Configuration/tile$i/mailserver/Software_Configuration
        mkdir -p $mailsoftdir
        scp 192.1.$i.3:/var/run/dovecot/dovecot.conf $mailsoftdir
        scp 192.1.$i.3:/var/log/dovecot $mailsoftdir
        
        websoftdir=data_collection/Virtual_Configuration/tile$i/webserver/Software_Configuration
        mkdir -p $websoftdir
        scp 192.1.$i.2:/etc/php.ini $websoftdir
        scp 192.1.$i.2:/etc/httpd/conf/httpd.conf $websoftdir
        
        for((j=1;j<=6;j++))
        do	
            if [ $j == 1 ];then
                vmdir=data_collection/Virtual_Configuration/tile$i/infraserver/VM_configuration
            fi
            if [ $j == 2 ];then
                vmdir=data_collection/Virtual_Configuration/tile$i/webserver/VM_configuration
            fi
            if [ $j == 3 ];then
                vmdir=data_collection/Virtual_Configuration/tile$i/mailserver/VM_configuration
            fi
            if [ $j == 4 ];then
                vmdir=data_collection/Virtual_Configuration/tile$i/appserver/VM_configuration
            fi
            if [ $j == 5 ];then
	        continue
            fi
            if [ $j == 6 ];then
                vmdir=data_collection/Virtual_Configuration/tile$i/batchserver/VM_configuration
            fi
            mkdir -p $vmdir/boot/grub/
            scp 192.1.$i.$j:/boot/grub/grub.conf $vmdir/boot/grub/
            mkdir -p  $vmdir/etc/iproute2
            mkdir -p  $vmdir/etc/rc.d/init.d
            mkdir -p  $vmdir/etc/rc.d/rc3.d
            scp 192.1.$i.$j:/etc/iproute2/* $vmdir/etc/iproute2/
            scp -r 192.1.$i.$j:/etc/rc.d/init.d/* $vmdir/etc/rc.d/init.d
            scp 192.1.$i.$j:/etc/rc.d/rc3.d/* $vmdir/etc/rc.d/rc3.d
            scp 192.1.$i.$j:/etc/fstab $vmdir/etc
            scp 192.1.$i.$j:/etc/hosts $vmdir/etc
            scp 192.1.$i.$j:/etc/inittab $vmdir/etc
            scp 192.1.$i.$j:/etc/nsswitch.conf $vmdir/etc
            scp 192.1.$i.$j:/etc/sysctl.conf $vmdir/etc
            scp 192.1.$i.$j:/etc/rc.local $vmdir/etc
            scp 192.1.$i.$j:/etc/bashrc $vmdir/etc
            mkdir -p  $vmdir/etc/sysconfig/network-scripts/
            scp 192.1.$i.$j:/etc/sysconfig/network-scripts/ifcfg* $vmdir/etc/sysconfig/network-scripts
            scp 192.1.$i.$j:/etc/sysconfig/network $vmdir/etc/sysconfig
	    mkdir -p $vmdir/etc/modprobe.d
	    scp 192.1.$i.$j:/etc/modprobe.d/ixgbevf.conf $vmdir/etc/modprobe.d/
            mkdir -p  $vmdir/proc
            ssh 192.1.$i.$j "cat /proc/cmdline" > $vmdir/proc/cmdline
            ssh 192.1.$i.$j "cat /proc/cpuinfo" > $vmdir/proc/cpuinfo
            ssh 192.1.$i.$j "cat /proc/devices" > $vmdir/proc/devices
            ssh 192.1.$i.$j "cat /proc/meminfo" > $vmdir/proc/meminfo
            ssh 192.1.$i.$j "cat /proc/modules" > $vmdir/proc/modules
            ssh 192.1.$i.$j "cat /proc/mounts" > $vmdir/proc/mounts
            ssh 192.1.$i.$j "cat /proc/partitions" > $vmdir/proc/partitions
            ssh 192.1.$i.$j "cat /proc/swaps" > $vmdir/proc/swaps
            ssh 192.1.$i.$j "cat /proc/version" > $vmdir/proc/version
            ssh 192.1.$i.$j "chkconfig" > $vmdir/chkconfig.txt
            ssh 192.1.$i.$j "df" > $vmdir/df.txt
            ssh 192.1.$i.$j "ifconfig" > $vmdir/ifconfig.txt
            ssh 192.1.$i.$j "lspci" > $vmdir/lspci.txt
            ssh 192.1.$i.$j "mount" > $vmdir/mount.txt
            ssh 192.1.$i.$j "rpm -qa" > $vmdir/rpmpkgs.txt
	    mkdir -p  $vmdir/etc/security
	    scp 192.1.$i.$j:/etc/security/limits.conf  $vmdir/etc/security/
        done
    done
    for((i=1;i<=$1;))
    do
        dbsoftdir=data_collection/Virtual_Configuration/tile$i/dbserver/Software_Configuration
        mkdir -p $dbsoftdir
        scp 192.1.$i.5:/etc/my.cnf $dbsoftdir
        #scp 192.1.$i.5:/opt/other_scripts/loaddb_postgres.sh $dbsoftdir
	mkdir -p $dbsoftdir/schema
        scp -r 192.1.$i.5:/opt/SUNWjAppServer2004/schema/mysql*/* $dbsoftdir/schema/
        ssh 192.1.$i.5 "mysql --version" >  $dbsoftdir/mysql-Version.txt
	vmdir=data_collection/Virtual_Configuration/tile$i/dbserver/VM_configuration
        mkdir -p $vmdir/boot/grub/
        scp 192.1.$i.5:/boot/grub/grub.conf $vmdir/boot/grub/
        mkdir -p  $vmdir/etc/iproute2
        mkdir -p  $vmdir/etc/rc.d/init.d
        mkdir -p  $vmdir/etc/rc.d/rc3.d
        scp 192.1.$i.5:/etc/iproute2/* $vmdir/etc/iproute2/
        scp -r 192.1.$i.5:/etc/rc.d/init.d/* $vmdir/etc/rc.d/init.d
        scp 192.1.$i.5:/etc/rc.d/rc3.d/* $vmdir/etc/rc.d/rc3.d
        scp 192.1.$i.5:/etc/fstab $vmdir/etc
        scp 192.1.$i.5:/etc/hosts $vmdir/etc
        scp 192.1.$i.5:/etc/inittab $vmdir/etc
        scp 192.1.$i.5:/etc/nsswitch.conf $vmdir/etc
        scp 192.1.$i.5:/etc/sysctl.conf $vmdir/etc
        scp 192.1.$i.5:/etc/rc.local $vmdir/etc
        scp 192.1.$i.5:/etc/bashrc $vmdir/etc
        mkdir -p  $vmdir/etc/sysconfig/network-scripts/
        scp 192.1.$i.5:/etc/sysconfig/network-scripts/ifcfg* $vmdir/etc/sysconfig/network-scripts
        scp 192.1.$i.5:/etc/sysconfig/network $vmdir/etc/sysconfig
        mkdir -p $vmdir/etc/modprobe.d
        scp 192.1.$i.$j:/etc/modprobe.d/ixgbevf.conf $vmdir/etc/modprobe.d/
        mkdir -p  $vmdir/proc
        ssh 192.1.$i.5 "cat /proc/cmdline" > $vmdir/proc/cmdline
        ssh 192.1.$i.5 "cat /proc/cpuinfo" > $vmdir/proc/cpuinfo
        ssh 192.1.$i.5 "cat /proc/devices" > $vmdir/proc/devices
        ssh 192.1.$i.5 "cat /proc/meminfo" > $vmdir/proc/meminfo
        ssh 192.1.$i.5 "cat /proc/modules" > $vmdir/proc/modules
        ssh 192.1.$i.5 "cat /proc/mounts" > $vmdir/proc/mounts
        ssh 192.1.$i.5 "cat /proc/partitions" > $vmdir/proc/partitions
        ssh 192.1.$i.5 "cat /proc/swaps" > $vmdir/proc/swaps
        ssh 192.1.$i.5 "cat /proc/version" > $vmdir/proc/version
        ssh 192.1.$i.5 "chkconfig" > $vmdir/chkconfig.txt
        ssh 192.1.$i.5 "df" > $vmdir/df.txt
        ssh 192.1.$i.5 "ifconfig" > $vmdir/ifconfig.txt
        ssh 192.1.$i.5 "lspci" > $vmdir/lspci.txt
        ssh 192.1.$i.5 "mount" > $vmdir/mount.txt
        ssh 192.1.$i.5 "rpm -qa" > $vmdir/rpmpkgs.txt
        mkdir -p  $vmdir/etc/security
	scp 192.1.$i.$j:/etc/security/limits.conf  $vmdir/etc/security/

        i=$((i+4))
    done
}

fn_main()
{
    date > data_collection/data-collection-start.txt

    fn_getClientInfo 23
    fn_getSUTInfo 23
    fn_getSUTVMInfo 23
    date > data_collection/data-collection-end.txt

}
fn_main

