#! /bin/bash
prefix=vp-
client_vm_topology="vp-ct01:vp-vct01,vp-vct02,vp-vct03,vp-vct04,vp-vct17,vp-vct18,vp-vct25::vp-ct02:vp-vct05,vp-vct06,vp-vct07,vp-vct08,vp-vct19,vp-vct20,vp-vct26::vp-ct03:vp-vct09,vp-vct10,vp-vct11,vp-vct12,vp-vct21,vp-vct22,vp-vct27::vp-ct04:vp-vct13,vp-vct14,vp-vct15,vp-vct16,vp-vct23,vp-vct24,vp-vct28::vp-master"
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering client data..."
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*'

for phys_client_and_vms in ${client_vm_topology//::/ }; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    mkdir -p $phys_client
    pushd $phys_client >/dev/null
    ssh $SSH_OPTIONS $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cat_files; do
        ssh $SSH_OPTIONS $phys_client "cat /$file" >$file
    done
    ssh $SSH_OPTIONS $phys_client ifconfig -a >ifconfig.txt
    ssh $SSH_OPTIONS $phys_client brctl show >brctl-show.txt
    ssh $SSH_OPTIONS $phys_client chkconfig --list >chkconfig.txt
    ssh $SSH_OPTIONS $phys_client mount -l >mount.txt
    ssh $SSH_OPTIONS $phys_client df >df.txt
    ssh $SSH_OPTIONS $phys_client lspci >lspci.txt
    ssh $SSH_OPTIONS $phys_client rpm -qa >rpmpkgs.txt
    ssh $SSH_OPTIONS $phys_client vgdisplay >vgdisplay.txt
    ssh $SSH_OPTIONS $phys_client lvdisplay >lvdisplay.txt
    ssh $SSH_OPTIONS $phys_client "ps aux | grep qemu-kvm | grep -v grep" >running-vms.txt
    ssh $SSH_OPTIONS $phys_client "virsh list" >virsh-list.txt
    vm_clients=`echo $phys_client_and_vms | sed -e s/"^${phys_client}:"//`
    for vm_client in ${vm_clients//,/ }; do
        echo "  vm_client is $vm_client"
        zpt=`echo $vm_client | sed -e 's/.*t\([0-9]\+\)$/\1/'`
        mkdir -p tile${zpt}
        pushd tile${zpt} >/dev/null
        ssh $SSH_OPTIONS $vm_client "cd /; tar chf - $tar_files" | tar xf -
        mkdir proc
        for file in $cat_files; do
            ssh $SSH_OPTIONS $vm_client cat /$file >$file
        done
        ssh $SSH_OPTIONS $vm_client ifconfig -a >ifconfig.txt
        ssh $SSH_OPTIONS $vm_client chkconfig --list >chkconfig.txt
        ssh $SSH_OPTIONS $vm_client mount -l >mount.txt
        ssh $SSH_OPTIONS $vm_client df >df.txt
        ssh $SSH_OPTIONS $vm_client lspci >lspci.txt
        ssh $SSH_OPTIONS $vm_client rpm -qa >rpmpkgs.txt
        mkdir -p SPECjAppServer2004/config
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/appsserver SPECjAppServer2004/config/
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/run.properties SPECjAppServer2004/config/
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/default.env SPECjAppServer2004/config/
        mkdir SPECweb2005
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/Test.config SPECweb2005/
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/SPECweb_Support.config SPECweb2005/
        mkdir SPECimap
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_config.rc SPECimap/
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_fixed.rc SPECimap/
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_sysinfo.rc SPECimap/
        mkdir SPECbatch
        scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECbatch-prime/Test.config SPECbatch/
        popd >/dev/null
    done
    popd >/dev/null
done
