#! /bin/bash
sut=vp-host
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering SUT data..."
if [ -e ~/README-SUT-notes.txt ]; then
    cp -p ~/README-SUT-notes.txt .
fi
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps proc/mounts proc/version proc/cmdline'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/sysctl.conf etc/security/limits* etc/modprobe* etc/rc.local /etc/cgconfig.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/*t??.sh etc/kvm/*ifup* root/do_renice.sh'
ssh $SSH_OPTIONS $sut "cd /; tar chf - $tar_files" | tar xf -
mkdir proc
for file in $cat_files; do
    ssh $SSH_OPTIONS $sut "cat /$file" >$file
done
ssh $SSH_OPTIONS $sut ifconfig -a >ifconfig.txt
ssh $SSH_OPTIONS $sut brctl show >brctl-show.txt
ssh $SSH_OPTIONS $sut chkconfig --list >chkconfig.txt
ssh $SSH_OPTIONS $sut mount -l >mount.txt
ssh $SSH_OPTIONS $sut df >df.txt
ssh $SSH_OPTIONS $sut lspci >lspci.txt
ssh $SSH_OPTIONS $sut rpm -qa >rpmpkgs.txt
ssh $SSH_OPTIONS $sut vgdisplay >vgdisplay.txt
ssh $SSH_OPTIONS $sut lvdisplay >lvdisplay.txt
ssh $SSH_OPTIONS $sut "ps axlf | grep qemu-kvm | grep -v grep" >running-vms.txt
ssh $SSH_OPTIONS $sut "virsh list" >virsh-list.txt
