#! /bin/bash
prefix=vd-
client_vm_topology="vn-ct03:vd-vct01,vd-vct09,vd-vct17,vd-vct25,vd-vct33,vd-vct41,vd-vct49,vd-vct57,vd-vct65::vn-ct04:vd-vct02,vd-vct10,vd-vct18,vd-vct26,vd-vct34,vd-vct42,vd-vct50,vd-vct58,vd-vct66::vn-ct05:vd-vct03,vd-vct11,vd-vct19,vd-vct27,vd-vct35,vd-vct43,vd-vct51,vd-vct59,vd-vct67::vn-ct06:vd-vct04,vd-vct12,vd-vct20,vd-vct28,vd-vct36,vd-vct44,vd-vct52,vd-vct60,vd-vct68::vn-ct07:vd-vct05,vd-vct13,vd-vct21,vd-vct29,vd-vct37,vd-vct45,vd-vct53,vd-vct61::vn-ct08:vd-vct06,vd-vct14,vd-vct22,vd-vct30,vd-vct38,vd-vct46,vd-vct54,vd-vct62::vn-ct09:vd-vct07,vd-vct15,vd-vct23,vd-vct31,vd-vct39,vd-vct47,vd-vct55,vd-vct63::vn-ct10:vd-master,vd-vct08,vd-vct16,vd-vct24,vd-vct32,vd-vct40,vd-vct48,vd-vct56,vd-vct64"
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering client data..."
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/rc.local etc/sysctl.conf usr/lib/sysctl.d/*specvirt.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/ etc/kvm/*ifup*'

client_number=0
for phys_client_and_vms in ${client_vm_topology//::/ }; do
    phys_client=`echo $phys_client_and_vms | awk -F: '{print $1}'`
    echo "phys_client is $phys_client"
    ((client_number++))
    mkdir -p Client${client_number}
    pushd Client${client_number} >/dev/null
    mkdir OS
    pushd OS >/dev/null
    ssh $SSH_OPTIONS $phys_client "cd /; tar chf - $tar_files" | tar xf -
    mkdir -p proc
    for file in $cat_files; do
        ssh $SSH_OPTIONS $phys_client "cat /$file" >$file
    done
    ssh $SSH_OPTIONS $phys_client ifconfig -a >ifconfig.txt
    ssh $SSH_OPTIONS $phys_client brctl show >brctl-show.txt
    ssh $SSH_OPTIONS $phys_client chkconfig --list &>chkconfig.txt
    if grep -q list-unit-files chkconfig.txt; then
        ssh $SSH_OPTIONS $phys_client systemctl list-unit-files >systemctl.list-unit-files.txt
    fi
    ssh $SSH_OPTIONS $phys_client mount -l >mount.txt
    ssh $SSH_OPTIONS $phys_client df >df.txt
    ssh $SSH_OPTIONS $phys_client lspci >lspci.txt
    ssh $SSH_OPTIONS $phys_client rpm -qa >rpmpkgs.txt
    ssh $SSH_OPTIONS $phys_client vgdisplay >vgdisplay.txt
    ssh $SSH_OPTIONS $phys_client lvdisplay >lvdisplay.txt
    ssh $SSH_OPTIONS $phys_client "ps -eLlfww | grep -E 'qemu|COMMAND' | grep -v grep" >running-vms.txt
    ssh $SSH_OPTIONS $phys_client "virsh --readonly list" >virsh-list.txt
    scp -p $SSH_OPTIONS $phys_client:/autobench/logs/specvirt*/benchmark/ulimits.txt .
    if [ ! -e ulimits.txt ]; then
        ssh $SSH_OPTIONS $phys_client "ulimit -a" >ulimits.txt
    fi
    popd >/dev/null
    vm_clients=`echo $phys_client_and_vms | sed -e s/^${phys_client}':*'//`
    if [ -n "$vm_clients" ]; then
        mkdir -p guest-xml-config
        pushd guest-xml-config >/dev/null
        for vm_client in ${vm_clients//,/ }; do
            scp -p $SSH_OPTIONS ${phys_client}:/autobench/logs/null-bench*/config/libvirt.guest.before.001/${vm_client}.xml .
        done
        popd >/dev/null

        for vm_client in ${vm_clients//,/ }; do
            echo "  vm_client is $vm_client"
            tile_num=`echo $vm_client | sed -e 's/.*t0*\([0-9]\+\)$/\1/'`
            if [ "$tile_num" != "$vm_client" ]; then
                mkdir -p Tile${tile_num}
                pushd Tile${tile_num} >/dev/null
            else
                mkdir -p ${vm_client#$prefix}
                pushd ${vm_client#$prefix} >/dev/null
            fi
            mkdir OS
            pushd OS >/dev/nell
            ssh $SSH_OPTIONS $vm_client "cd /; tar chf - $tar_files" | tar xf -
            mkdir proc
            for file in $cat_files; do
                ssh $SSH_OPTIONS $vm_client cat /$file >$file
            done
            ssh $SSH_OPTIONS $vm_client ifconfig -a >ifconfig.txt
            ssh $SSH_OPTIONS $vm_client chkconfig --list &>chkconfig.txt
            if grep -q list-unit-files chkconfig.txt; then
                ssh $SSH_OPTIONS $vm_client systemctl list-unit-files >systemctl.list-unit-files.txt
            fi
            ssh $SSH_OPTIONS $vm_client mount -l >mount.txt
            ssh $SSH_OPTIONS $vm_client df >df.txt
            ssh $SSH_OPTIONS $vm_client lspci >lspci.txt
            ssh $SSH_OPTIONS $vm_client rpm -qa >rpmpkgs.txt
            scp -p $SSH_OPTIONS $vm_client:/autobench/logs/specvirt*/benchmark/ulimits.txt .
            popd >/dev/null
            mkdir -p SPECjAppServer2004
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/appsserver SPECjAppServer2004/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/run.properties SPECjAppServer2004/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECjAppServer2004-prime/config/default.env SPECjAppServer2004/
            mkdir SPECweb2005
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/Test.config SPECweb2005/
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECweb2005-prime/SPECweb_Support.config SPECweb2005/
            mkdir SPECimap
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECimap-prime/IMAP_config.rc SPECimap/
            mkdir SPECbatch
            scp -p $SSH_OPTIONS $vm_client:/autobench/sources/SPECvirt_sc2013/SPECbatch-prime/Test.config SPECbatch/
            popd >/dev/null
        done
    fi
    popd >/dev/null
done
