#! /bin/bash
MYDIR=$(readlink -e ${0%/*})
sut=vq-host
SSH_OPTIONS="-o IdentityFile=/autobench/ssh/autobench-id -o StrictHostKeyChecking=no"
echo "Gathering SUT data..."
if [ -e ~/README-SUT-notes.txt ]; then
    cp -p ~/README-SUT-notes.txt .
fi
cat_files='proc/cpuinfo proc/devices proc/meminfo proc/modules proc/partitions proc/swaps proc/mounts proc/version proc/cmdline'
tar_files='boot/grub/grub.conf boot/efi/EFI/redhat/grub.conf boot/grub2/grub.cfg etc/os-release etc/fstab etc/hosts etc/inittab etc/iproute2 etc/nsswitch.conf etc/sysctl.conf usr/lib/sysctl.d/*specvirt.conf etc/security/limits* etc/modprobe* etc/rc.local etc/cgconfig.conf etc/rc.d/rc3.d/ etc/rc.d/init.d/ var/log/dmesg etc/kvm/vm-scripts/*t[0-9]*.sh etc/kvm/*ifup* etc/tune-profiles/active-profile etc/tuned/active_profile root/renice.sh usr/lib/systemd/system/enable-modprobe-vfs.service usr/local/bin/enable-modprobe-vfs.sh'
mkdir OS
pushd OS >/dev/null
ssh $SSH_OPTIONS $sut "cd /; tar chf - $tar_files" | tar xf -
mkdir proc
for file in $cat_files; do
    ssh $SSH_OPTIONS $sut "cat /$file" >$file
done
ssh $SSH_OPTIONS $sut chkconfig --list &>chkconfig.txt
if grep -q list-unit-files chkconfig.txt; then
    ssh $SSH_OPTIONS $sut systemctl list-unit-files >systemctl.list-unit-files.txt
fi
ssh $SSH_OPTIONS $sut lspci >lspci.txt
ssh $SSH_OPTIONS $sut dmidecode >dmidecode.txt
ssh $SSH_OPTIONS $sut 'rpm -qa | sort' >rpmpkgs.txt
scp -p $SSH_OPTIONS $sut:/autobench/logs/specvirt*/benchmark/ulimits.txt .
ssh $SSH_OPTIONS $sut 'grep . /sys/devices/system/cpu/vulnerabilities/*' >vulnerabilities.txt
scp -p $SSH_OPTIONS $MYDIR/spectre-meltdown-checker.sh $sut:/root/
ssh $SSH_OPTIONS $sut "/root/spectre-meltdown-checker.sh" >spectre-meltdown-checker.out.txt
popd >/dev/null
mkdir Storage
ssh $SSH_OPTIONS $sut mount -l >Storage/mount.txt
ssh $SSH_OPTIONS $sut df >Storage/df.txt
ssh $SSH_OPTIONS $sut vgdisplay >Storage/vgdisplay.txt
ssh $SSH_OPTIONS $sut lvdisplay >Storage/lvdisplay.txt
mkdir Network
ssh $SSH_OPTIONS $sut ifconfig -a >Network/ifconfig.txt
ssh $SSH_OPTIONS $sut brctl show >Network/brctl-show.txt
mkdir SOFTW
ssh $SSH_OPTIONS $sut "ps -eLlfww | grep -E 'qemu|PID' | grep -v grep" >SOFTW/running-vms.txt
ssh $SSH_OPTIONS $sut "virsh --readonly list" >SOFTW/virsh-list.txt
mkdir -p guest-xml-config
scp -p $SSH_OPTIONS ${sut}:/autobench/logs/specvirt*/config/libvirt.guest.before.001/*[0-9].xml guest-xml-config/
