SET default_tablespace=jappdata;

ALTER TABLE public.u_sequences OWNER TO spec;

--
-- Name: c_customer_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY c_customer
    ADD CONSTRAINT c_customer_pkey PRIMARY KEY (c_id);


--
-- Name: c_customerinventory_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY c_customerinventory
    ADD CONSTRAINT c_customerinventory_pkey PRIMARY KEY (ci_id);


--
-- Name: c_parts_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY c_parts
    ADD CONSTRAINT c_parts_pkey PRIMARY KEY (p_id);


--
-- Name: c_site_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY c_site
    ADD CONSTRAINT c_site_pkey PRIMARY KEY (site_id);


--
-- Name: c_supplier_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY c_supplier
    ADD CONSTRAINT c_supplier_pkey PRIMARY KEY (supp_id);


--
-- Name: m_bom_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY m_bom
    ADD CONSTRAINT m_bom_pkey PRIMARY KEY (b_assembly_id, b_comp_id, b_line_no);


--
-- Name: m_inventory_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY m_inventory
    ADD CONSTRAINT m_inventory_pkey PRIMARY KEY (in_p_id);


--
-- Name: m_largeorder_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY m_largeorder
    ADD CONSTRAINT m_largeorder_pkey PRIMARY KEY (lo_id);


--
-- Name: m_parts_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY m_parts
    ADD CONSTRAINT m_parts_pkey PRIMARY KEY (p_id);


--
-- Name: m_workorder_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY m_workorder
    ADD CONSTRAINT m_workorder_pkey PRIMARY KEY (wo_number);


--
-- Name: o_item_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY o_item
    ADD CONSTRAINT o_item_pkey PRIMARY KEY (i_id);


--
-- Name: o_orderline_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY o_orderline
    ADD CONSTRAINT o_orderline_pkey PRIMARY KEY (ol_o_id, ol_id);


--
-- Name: o_orders_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY o_orders
    ADD CONSTRAINT o_orders_pkey PRIMARY KEY (o_id);


--
-- Name: s_component_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY s_component
    ADD CONSTRAINT s_component_pkey PRIMARY KEY (comp_id);


--
-- Name: s_purchase_order_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY s_purchase_order
    ADD CONSTRAINT s_purchase_order_pkey PRIMARY KEY (po_number);


--
-- Name: s_purchase_orderline_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY s_purchase_orderline
    ADD CONSTRAINT s_purchase_orderline_pkey PRIMARY KEY (pol_po_id, pol_number);


--
-- Name: s_site_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY s_site
    ADD CONSTRAINT s_site_pkey PRIMARY KEY (site_id);


--
-- Name: s_supp_component_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY s_supp_component
    ADD CONSTRAINT s_supp_component_pkey PRIMARY KEY (sc_p_id, sc_supp_id);


--
-- Name: s_supplier_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY s_supplier
    ADD CONSTRAINT s_supplier_pkey PRIMARY KEY (supp_id);


--
-- Name: txn_log_table_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY txn_log_table
    ADD CONSTRAINT txn_log_table_pkey PRIMARY KEY (localtid, servername);


--
-- Name: u_sequences_pkey; Type: CONSTRAINT; Schema: public; Owner: spec; Tablespace: 
--

ALTER TABLE ONLY u_sequences
    ADD CONSTRAINT u_sequences_pkey PRIMARY KEY (s_id);


--
-- Name: c_custci_idx; Type: INDEX; Schema: public; Owner: spec; Tablespace: 
--

CREATE INDEX c_custci_idx ON c_customerinventory USING btree (ci_customerid);


--
-- Name: m_lo_cat_idx; Type: INDEX; Schema: public; Owner: spec; Tablespace: 
--

CREATE INDEX m_lo_cat_idx ON m_largeorder USING btree (lo_category);


--
-- Name: m_lo_o_idx; Type: INDEX; Schema: public; Owner: spec; Tablespace: 
--

CREATE UNIQUE INDEX m_lo_o_idx ON m_largeorder USING btree (lo_o_id, lo_ol_id);


--
-- Name: o_icat_idx; Type: INDEX; Schema: public; Owner: spec; Tablespace: 
--

CREATE INDEX o_icat_idx ON o_item USING btree (i_category);


--
-- Name: o_oc_idx; Type: INDEX; Schema: public; Owner: spec; Tablespace: 
--

CREATE INDEX o_oc_idx ON o_orders USING btree (o_c_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--
