#!/usr/bin/env bash
#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################
db2set DB2_COLLECT_TS_REC_INFO=FALSE 
db2set DB2_KEEPTABLELOCK=CONNECTION
db2set DB2_MINIMIZE_LISTPREFETCH=YES
db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
db2set DB2FCMCOMM=TCPIP4
db2set DB2TCP_CLIENT_CONTIMEOUT=0
db2set DB2TCP_CLIENT_RCVTIMEOUT=0
db2set DB2TCPCONNMGRS=8
db2set DB2ENVLIST=LD_PRELOAD LD_LIBRARY_PATH
db2set DB2SOSNDBUF=131072
db2set DB2SORCVBUF=131072
db2set DB2AUTOSTART=NO
#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################
db2 -v update dbm cfg using DIAGLEVEL 3
db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK off DFT_MON_SORT off DFT_MON_STMT off DFT_MON_TIMESTAMP on DFT_MON_UOW off DFT_MON_TABLE off 
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using SVCENAME 50000 
db2 -v update dbm cfg using MAX_COORDAGENTS 10000 automatic #MAX_CONNECTIONS 3650
db2 -v update dbm cfg using HEALTH_MON off
db2 -v update dbm cfg using SHEAPTHRES 2000000
db2 -v connect to specdb user db2inst1 using q3wertyu
############################################
# DATABASE CONFIGURATION TUNING            #
############################################
db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using LOGSECOND 0
db2stop force
ipclean -a
db2start
db2 -v activate db specdb
db2 -v connect to specdb user db2inst1 using q3wertyu
db2 -v update db cfg for specdb using LOGPRIMARY 256
db2 -v update db cfg for specdb using SOFTMAX 8080
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99
db2 -v update db cfg for specdb using LOGFILSIZ 65535
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using SHEAPTHRES_SHR 183205 SORTHEAP 50000 
db2 -v update db cfg for specdb using NUM_IOCLEANERS 32 
db2 -v update db cfg for specdb using MAXAPPLS 2246
db2 -v update db cfg for specdb using MAXLOCKS 100 LOCKLIST 200000 
db2 -v update db cfg for specdb using MINCOMMIT 1 
db2 -v update db cfg for specdb using MON_REQ_METRICS base
db2 -v update db cfg for specdb using MON_ACT_METRICS base
db2 -v update db cfg for specdb using MON_OBJ_METRICS none
db2 -v update db cfg for specdb using AUTO_STMT_STATS off
db2stop force
db2start
db2 -v connect to specdb user db2inst1 using q3wertyu
############################################
# BUFFER POOL TUNING                       #
############################################
db2 -v connect to specdb user db2inst1 using q3wertyu
db2 alter bufferpool ibmdefaultbp size 12000000
############################################
# TABLE TUNING                             #
############################################
db2 -v terminate
db2set DB2COMM=TCPIP
db2stop force
db2start
