CREATE TABLE I_POLICY_COVERAGE (COVERAGE_ID BIGINT NOT NULL, COVERAGE INTEGER, DEDUCTIBLE INTEGER, coverage_limit INTEGER, PRICE BIGINT, INSURANCE_ID BIGINT, PRIMARY KEY (COVERAGE_ID))
CREATE INDEX I_POLICY_COVERAGE_INSURANCE_ID ON I_POLICY_COVERAGE (INSURANCE_ID)
CREATE TABLE I_POLICYHOLDER (ID BIGINT NOT NULL, ACCIDENTS INTEGER, BIRTHDATE DATE NOT NULL, CLAIMS INTEGER, EMAIL VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(25) NOT NULL, GENDER INTEGER NOT NULL, LASTNAME VARCHAR(25) NOT NULL, MIDDLENAME VARCHAR(25), MOVINGVIOLATIONS INTEGER, PASSWORD VARCHAR(255) NOT NULL, PRELOADINDEX INTEGER, CITY VARCHAR(30) NOT NULL, COUNTRY VARCHAR(25) NOT NULL, PHONE VARCHAR(12) NOT NULL, STATE VARCHAR(25) NOT NULL, STREET1 VARCHAR(30) NOT NULL, STREET2 VARCHAR(25), ZIP VARCHAR(25) NOT NULL, PRIMARY KEY (ID))
CREATE INDEX I_POLICYHOLDER_EMAIL ON I_POLICYHOLDER (email)
CREATE TABLE U_MICROSERVICE (TYPE VARCHAR(255) NOT NULL, BASEPATH VARCHAR(255), HOST VARCHAR(255), PORT INTEGER, PROTOCOL INTEGER, PRIMARY KEY (TYPE))
CREATE TABLE I_VEHICLE (VIN VARCHAR(17) NOT NULL, ANNUAL_MILES INTEGER NOT NULL, DESCRIPTION_ID BIGINT NOT NULL, INSURANCE_ID BIGINT, POLICY_HOLDER_ID BIGINT, PRIMARY KEY (VIN))
CREATE INDEX I_VEHICLE_INSURANCE_ID ON I_VEHICLE (INSURANCE_ID)
CREATE INDEX I_VEHICLE_POLICY_HOLDER_ID ON I_VEHICLE (POLICY_HOLDER_ID)
CREATE TABLE I_VEHICLE_INSURANCE (INSURANCE_ID BIGINT NOT NULL, ANNUAL_PREMIUM BIGINT, COMPANY VARCHAR(75), PRIMARY KEY (INSURANCE_ID))
ALTER TABLE I_POLICYHOLDER ADD CONSTRAINT I_POLICYHOLDER0 UNIQUE (email)
ALTER TABLE I_POLICY_COVERAGE ADD CONSTRAINT PLCYCVERAGENSRNCID FOREIGN KEY (INSURANCE_ID) REFERENCES I_VEHICLE_INSURANCE (INSURANCE_ID)
ALTER TABLE I_VEHICLE ADD CONSTRAINT VHICLEPLCYHOLDERID FOREIGN KEY (POLICY_HOLDER_ID) REFERENCES I_POLICYHOLDER (ID)
ALTER TABLE I_VEHICLE ADD CONSTRAINT VEHICLEINSURANCEID FOREIGN KEY (INSURANCE_ID) REFERENCES I_VEHICLE_INSURANCE (INSURANCE_ID)
CREATE SEQUENCE i_policy_coverage_sequence INCREMENT BY 10000 START WITH 10000
CREATE SEQUENCE i_policy_holder_sequence INCREMENT BY 1000 START WITH 1000
CREATE SEQUENCE i_vehicle_insurance_sequence INCREMENT BY 10000 START WITH 10000
