#!/bin/sh

BINDIR=`dirname $0`

if [ -n "$BINDIR" ]
then
    JAS_HOME=`cd $BINDIR/.. > /dev/null 2>&1 && pwd`
    export JAS_HOME
fi

# Configuration file location
CONFIG_DIR=${JAS_HOME}/config

# We check for the apps server and load the necessary environment
# to make a run
APPSSERVER=`cat ${CONFIG_DIR}/appsserver`
echo "Apps server is ${APPSSERVER}"

ENVFILE=${CONFIG_DIR}/${APPSSERVER}.env

if [ ! -f ${ENVFILE} ] ; then
    echo "Cannot find ../config/${APPSSERVER}.env" >&2
    exit 1
fi

. ${ENVFILE}

PATH=$JAVA_HOME/bin${PATHSEP}$JAS_HOME/ant/bin${PATHSEP}$PATH
export PATH

WLS_CLASSPATH=$WL_HOME/server/lib/weblogic_sp.jar${CLASSPATHSEP}$WL_HOME/server/lib/weblogic.jar${CLASSPATHSEP}$JAS_HOME/classes
export WLS_CLASSPATH

# This script builds the SPECjAppServer.ear

${JAS_HOME}/ant/bin/ant -Dclasspath="$WLS_CLASSPATH" -Djas_home="$JAS_HOME" -Djava_home="$JAVA_HOME" -Dwl_home="$WL_HOME" -DAPPSSERVER="$APPSSERVER" -Dversion="$EJB_VERSION" -DMODE="$EJB_MODE" -Dejb_clusterable="$EJB_CLUSTERABLE" -Dcall_by_reference="$CALLBYREFERENCE" -Dejbc_arg="$EJBCARG" -Ddb_type="$DB_TYPE" -Ddb_url="$DB_URL" -Ddb_driver="$DB_DRIVER" -Djdbc_user="$JDBC_USER" -Djdbc_pass="$JDBC_PASS" -Ddb_server="$DB_SERVER" -Ddb_capacity="$DB_CAPACITY" -Ddb_prepcache="$DB_PREPCACHE" -Djas_prefix="$JAS_PREFIX" -Djas_multi_host="$JAS_MULTI_HOST" -Djas_host="$JAS_HOST" -Djas_port="$JAS_PORT" -Demulator_prefix="$EMULATOR_PREFIX" -Demulator_host="$EMULATOR_HOST" -Demulator_port="$EMULATOR_PORT" -Djas_tmp="$JAS_TMP" -Djas_output="$JAS_OUTPUT" -Djdbc_driver="$JDBC_DRIVER" -Djdbc_url="$JDBC_URL" -Dtxrate="$TXRATE" -Drampup="$RAMPUP" -Dstdystate="$STDYSTATE" -Drampdown="$RAMPDOWN" -Dtriggertime="$TRIGGERTIME" -f ${JAS_HOME}/build_wls.xml $1 $2 $3
